//
//  QGSendMessageCodeManger.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/25.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGSendMessageCodeManger.h"
#import "QGBasicUITool.h"
#import "QGJYVerifyCodeManager.h"
#import "QGCustomAlertView.h"
#import "QGTalosNetwork.h"
#import "QGLoginRequestApi.h"
//Model
#import "QGCaptchaNewModel.h"
#import "QGAnalyticsService.h"
@interface QGSendMessageCodeManger ()<QGCustomAlertViewDelegate>

///获取极验一验数据，并且判断弹出极验还是自己的图形验证码
@property (nonatomic, strong) QGCaptchaNewModel * captchaNewModel;

///图片验证码信息(获取imageId)
@property (nonatomic, strong) NSMutableDictionary *imageVerifyCodeInfo;
///图片验证码弹框
@property (strong, nonatomic) QGCustomAlertView *customAlertView;

///极验验证码工具
@property (nonatomic, strong) QGJYVerifyCodeManager * JYCodeManager;

@end

@implementation QGSendMessageCodeManger
-(instancetype)init
{
    if (self = [super init]) {
        //初始化极验
        self.JYCodeManager = [[QGJYVerifyCodeManager alloc]init];
    }
    
    return self;
}

-(void)sendMessageCodeWithPhoneNumber:(NSString *)phoneNum success:(SuccessSendCode)successBlock fail:(FailSendCode)failBlock
{
    _phoneString = phoneNum;
    _successBlock = successBlock;
    _failBlock = failBlock;
    
    [self requestVerifyCode];
}


/**
 第一步触发短信验证码 发送短信验证码 获取验证码请求，根据后台选择弹出极验还是量化派图形验证码
 */
-(void)requestVerifyCode
{
    NSString *urlString = [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodSmsCaptchaType];
    NSMutableDictionary * infoDic = [NSMutableDictionary dictionaryWithCapacity:0];
    [infoDic setObject:@"app" forKey:@"clientType"];
    [infoDic setObject:self.phoneString forKey:@"phoneNo"];
    
    [QGHUDManager showHud:nil];
    
    
    [[QGTalosNetwork shareManager] POST:urlString parameters:infoDic success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        //业务处理成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary * data = responseObject[@"data"];
            self.captchaNewModel = [QGCaptchaNewModel yy_modelWithDictionary:data];
            
            if ([self.captchaNewModel.verifyType isEqualToString:@"qg"]) {
                //弹出量化派验证码
                [self getImageCodeWithAlertView:YES];
            }else if ([self.captchaNewModel.verifyType isEqualToString:@"gt"]){
                //弹出极验验证码
                [self showJYVerifyCode];
            }
        }
        //业务处理失败
        else
        {
            //弹出异常提示
            [QGHUDManager showHudWithError:responseObject];
            if (self.failBlock) {
                self.failBlock();
            }
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        NSString * errorString = [QGBaseNetwork getMessageWithFailureError:error];
        [QGHUDManager showHud:errorString];
        if (self.failBlock) {
            self.failBlock();
        }
    }];
    
}



/**
 第二步 弹出极验验证弹窗
 */
- (void)showJYVerifyCode
{
    //调用起极验
    [self.JYCodeManager configureGTest:self.captchaNewModel.gt challenge:self.captchaNewModel.challenge success:@(self.captchaNewModel.success.boolValue) phoneNum:self.phoneString];
    
    self.JYCodeManager.cancleBlock = ^{
        
    };
    
    __weak typeof(self) weakSelf = self;
    self.JYCodeManager.successBlock = ^(NSString *geetest_challenge, NSString *geetest_seccode, NSString *geetest_validate) {
        //进行二验
        [weakSelf requestCaptchasV2WithGeetest_challenge:geetest_challenge geetest_seccode:geetest_seccode geetest_validate:geetest_validate captchaValue:nil captchaId:nil];
    };
    
}

/**
 第二步 请求图形验证码数据，并且是否需要弹窗
 */
- (void)getImageCodeWithAlertView:(BOOL)showCustomAlertView {
    
    NSString *urlString = [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodSmsCaptcha];
    
    [[QGTalosNetwork shareManager] GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
        //业务处理成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *json = (NSDictionary *)responseObject[@"data"];
            [self.imageVerifyCodeInfo setDictionary:json];
            if ([self.imageVerifyCodeInfo objectForKey:@"image"]) {
                //生成图片验证码的图片
                NSString *aString = [self.imageVerifyCodeInfo objectForKey:@"image"];
                NSArray *imageArray = [aString componentsSeparatedByString:@","];
                NSString *string = [imageArray[1] stringByReplacingOccurrencesOfString:@" " withString:@""];
                NSData *imageData = [[NSData alloc] initWithBase64EncodedString:string options:NSDataBase64DecodingIgnoreUnknownCharacters];
                //生成的验证码图片
                UIImage *image = [UIImage imageWithData:imageData];

                if (showCustomAlertView) {//调起图片验证
                    [self showCustomAlertViewImage:image];
                } else {//更新图片验证
                    self.customAlertView.vCodeImage = image;
                }
            }
        }
        //业务处理失败
        else
        {
            NSString *messageStr = [NSString stringWithFormat:@"%@", [responseObject objectForKey:@"msg"]];
            if (self.customAlertView.isShow) {
                [self.customAlertView showDropDownToastWithMessage:messageStr];
            } else {
                [QGHUDManager showHud:messageStr];
            }
        }
        
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        NSString * errorMsg = [QGBaseNetwork getMessageWithFailureError:error];
        [QGHUDManager showHud:errorMsg];
    }];
}


/**
 第三步 极验或者自己的图形验证完成后，实际触发短信的请求
 
 @param geetest_challenge 极验二验参数
 @param geetest_seccode 极验二验参数
 @param geetest_validate 极验二验参数
 @param captchaValue 量化派图形验证码校验参数
 @param captchaId 量化派图形验证码校验参数
 */
- (void)requestCaptchasV2WithGeetest_challenge:(NSString *)geetest_challenge geetest_seccode:(NSString *)geetest_seccode geetest_validate:(NSString *)geetest_validate captchaValue:(NSString *)captchaValue captchaId:(NSString *)captchaId
{
    
    //短信验证码
    NSMutableDictionary *paraDictM = [[NSMutableDictionary alloc] initWithCapacity:6];
    [paraDictM setValue:self.phoneString forKey:@"phoneNo"];
    [paraDictM setValue:@"VCC" forKey:@"smsMerchant"];
    [paraDictM setValue:[NSNumber numberWithInteger:registerFrom.integerValue] forKey:@"registerFrom"];
    
    //量化派图形验证码验证
    if (captchaValue && captchaId) {
        [paraDictM setValue:captchaValue forKey:@"captchaValue"];
        [paraDictM setValue:captchaId forKey:@"captchaId"];
    }
    
    //极验弹窗二验
    if (geetest_challenge && geetest_seccode && geetest_validate && [self.captchaNewModel.verifyType isEqualToString:@"gt"]) {
        [paraDictM setValue:@"gt" forKey:@"verifyType"];
        [paraDictM setValue:@"app" forKey:@"clientType"];
        [paraDictM setValue:self.captchaNewModel.uniqueKey forKey:@"uniqueKey"];
        [paraDictM setValue:geetest_challenge forKey:@"geetest_challenge"];
        [paraDictM setValue:geetest_validate forKey:@"geetest_validate"];
        [paraDictM setValue:geetest_seccode forKey:@"geetest_seccode"];
    }
    
    [paraDictM setValue:@"zhenxianghua" forKey:@"appName"];
    
    NSString *urlStr = [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodRegisterSendSms];
    [[QGTalosNetwork shareManager] POST:urlStr parameters:paraDictM success:^(id  _Nonnull responseObject) {
        //请求业务处理成功
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            
            //获取验证码成功埋点
            NSMutableDictionary *info = [[NSMutableDictionary alloc] init];
            [info setObject:@"APP注册" forKey:@"abse_page_name"];
            [info setObject:@"短验前置校验" forKey:@"abse_action_name"];
            [info setObject:@"success" forKey:@"abse_state_value"];
            [QGAnalyticsService analyticsTrack:@"AppBusinessStateEvent" withProperties: info];
            
            //隐藏自定义图形验证码弹窗
            if (self.customAlertView.isShow) {
                [self.customAlertView dismissAnimation:YES dismissBlock:NO];
            }
            
            [QGHUDManager showHud:@"验证码发送成功"];
            
            if (self.successBlock) {
                self.successBlock();
            }
        }
        //业务处理失败
        else
        {
            NSString * businessCode = responseObject[@"businessCode"];
            //图形验证码错误，重新请求图形验证码
            if ([businessCode isEqualToString:@"1003"]) {
                
                if (self.customAlertView.isShow) {
                   [self.customAlertView showDropDownToastWithMessage:@"图形验证码不正确"];
                }
                [self getImageCodeWithAlertView:YES];
            }
            else
            {
                if (self.customAlertView.isShow) {
                    [self.customAlertView dismissAnimation:YES dismissBlock:NO];
                }
                if (self.failBlock) {
                    self.failBlock();
                }
                [QGHUDManager showHudWithError:responseObject];
            }
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
        if (self.failBlock) {
            self.failBlock();
        }
    }];
}

//显示图形验证码
- (void)showCustomAlertViewImage:(UIImage *)image{
    
    self.customAlertView.vCodeImage = image;
    
    [self.customAlertView showAnimation:YES];
}

#pragma mark - QGCustomAlertViewDelegate
/**
 图片验证码按钮点击事件
 */
- (void)customAlertViewVerifyCodeImageViewClick:(QGCustomAlertView *)sender
{
    [self getImageCodeWithAlertView:NO];
}

/**
 确认按钮点击事件
 */
- (void)customAlertViewOKButtonClick:(QGCustomAlertView *)sender verifyCode:(NSString *)verifyCode
{
    [self requestCaptchasV2WithGeetest_challenge:nil geetest_seccode:nil geetest_validate:nil captchaValue:verifyCode captchaId:[self.imageVerifyCodeInfo objectForKey:@"imageId"]];
}



- (NSMutableDictionary *)imageVerifyCodeInfo {
    if (_imageVerifyCodeInfo == nil) {
        _imageVerifyCodeInfo = [[NSMutableDictionary alloc] initWithCapacity:1];
    }
    
    return _imageVerifyCodeInfo;
}


- (QGCustomAlertView *)customAlertView {
    if (_customAlertView == nil) {
        _customAlertView = [[QGCustomAlertView alloc] init];
        _customAlertView.delegate = self;
    }
    
    return _customAlertView;
}

@end
