//
//  QGCashbackHeaderCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/12.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCashbackIncomeCell.h"

#import "QGBasicUITool.h"
#import "QGGradientView.h"
#import "QGGradientShadowButton.h"
@interface QGCashbackIncomeCell ()

/// 返现余额
@property (nonatomic, strong) UILabel * cashbackAmountLabel;

/// 返现按钮
@property (nonatomic, strong) QGGradientShadowButton * cashbackButton;

/// 返现累计获得金额
@property (nonatomic, strong) UILabel * cashbackTotalAmountLabel;

/// 待返现金额
@property (nonatomic, strong) UILabel * cashbackWaitAmountLabel;

/// 本月收益预估金额
@property (nonatomic, strong) UILabel * expectMonthAmountLabel;

/// 今日收益预估
@property (nonatomic, strong) UILabel * expectTodayAmountLabel;

/// 上月收益预估金额
@property (nonatomic, strong) UILabel * expectLastMonthAmountLabel;

/// 上月结算预估
@property (nonatomic, strong) UILabel * paidLastMonthAmountLabel;
@end


@implementation QGCashbackIncomeCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
         
        //标题
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"我的收益" titleFontSize:[UIFont qg_mediumFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [titleLabel mas_updateConstraints:^(MASConstraintMaker *make) {
            make.left.inset(20);
            make.top.inset(18);
            make.height.mas_equalTo(25);
        }];
        
        //边框背景
        UIView * shadowView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor whiteColor]];
        [shadowView setShadowColor:[UIColor shadowColor] shadowRadius:4 shadowOffset:CGSizeMake(0, 2) cornerRadius:6];
        [shadowView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.mas_equalTo(titleLabel.mas_bottom).offset(10);
            make.height.mas_equalTo(273);
        }];
        
        //返现余额标题
        UILabel * cashbackAmountTitleLabel = [UILabel creatLabelWithSuperView:shadowView title:@"可提现余额(元)" titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [cashbackAmountTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(15);
            make.top.inset(18);
            make.height.mas_equalTo(17);
        }];
        
        //返现余额
        self.cashbackAmountLabel = [UILabel creatLabelWithSuperView:shadowView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:30] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.cashbackAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(15);
            make.top.mas_equalTo(cashbackAmountTitleLabel.mas_bottom).offset(0);
            make.height.mas_equalTo(42);
        }];
        
        //提现按钮
        self.cashbackButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:shadowView title:@"提现" textFont:[UIFont qg_regularFontOfSize:16]];
        [self.cashbackButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(15);
            make.size.mas_equalTo(CGSizeMake(80, 35));
            make.centerY.mas_equalTo(self.cashbackAmountLabel);
        }];
        
        //提现按钮点击事件
        @weakify(self);
        [self.cashbackButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            if (self.cashbackClickBlock) {
                self.cashbackClickBlock();
            }
        }];

        //累计返现标题
        UILabel * cashbackTotalAmountTitleLabel = [UILabel creatLabelWithSuperView:shadowView title:@"累计获得(元)" titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [cashbackTotalAmountTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(15);
            make.top.mas_equalTo(self.cashbackAmountLabel.mas_bottom).offset(12);
            make.height.mas_equalTo(17);
        }];
        
        //累计获得金额
        self.cashbackTotalAmountLabel = [UILabel creatLabelWithSuperView:shadowView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:16] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.cashbackTotalAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(15);
            make.top.mas_equalTo(cashbackTotalAmountTitleLabel.mas_bottom).offset(2);
            make.height.mas_equalTo(22);
        }];
        
        //累计获得金额箭头
        UIImageView * totalAmountArrowImg = [UIImageView creatImageViewWithSuperView:shadowView imageName:@"cashback_income_arrow"];
        [totalAmountArrowImg mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.cashbackTotalAmountLabel.mas_right).offset(8);
            make.size.mas_equalTo(CGSizeMake(6, 11));
            make.centerY.mas_equalTo(self.cashbackTotalAmountLabel);
        }];
        
        
        //累计获得返现按钮
        UIButton * totalAmountButton = [UIButton creatButtonWithSuperView:shadowView title:nil titleFont:nil textColor:nil];
        [totalAmountButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(0);
            make.top.mas_equalTo(cashbackTotalAmountTitleLabel.mas_top);
            make.bottom.mas_equalTo(self.cashbackTotalAmountLabel.mas_bottom);
            make.right.mas_equalTo(shadowView.mas_centerX);
        }];
        
        //累计获得提现按钮
        [totalAmountButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            if (self.totalAmountClickBlock) {
                self.totalAmountClickBlock();
            }
        }];
        
        //待返现金额标题
        UILabel * cashbackWaitAmountTitleLabel = [UILabel creatLabelWithSuperView:shadowView title:@"待返现(元)" titleFontSize:cashbackTotalAmountTitleLabel.font textColor:cashbackTotalAmountTitleLabel.textColor alignment:NSTextAlignmentLeft];
        [cashbackWaitAmountTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(shadowView.mas_centerX).offset(15);
            make.top.height.mas_equalTo(cashbackTotalAmountTitleLabel);
        }];
        
        /// 待返现金额
        self.cashbackWaitAmountLabel = [UILabel creatLabelWithSuperView:shadowView title:nil titleFontSize:self.cashbackTotalAmountLabel.font textColor:self.cashbackTotalAmountLabel.textColor alignment:NSTextAlignmentLeft];
        [self.cashbackWaitAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(cashbackWaitAmountTitleLabel);
            make.top.height.mas_equalTo(self.cashbackTotalAmountLabel);
        }];
        
        //累计获得金额箭头
        UIImageView * cashbackWaitAmountArrowImg = [UIImageView creatImageViewWithSuperView:shadowView imageName:@"cashback_income_arrow"];
        [cashbackWaitAmountArrowImg mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.cashbackWaitAmountLabel.mas_right).offset(8);
            make.size.mas_equalTo(CGSizeMake(6, 11));
            make.centerY.mas_equalTo(self.cashbackWaitAmountLabel);
        }];
        
        //待返现按钮
        UIButton * waitAmountButton = [UIButton creatButtonWithSuperView:shadowView title:nil titleFont:nil textColor:nil];
        [waitAmountButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(0);
            make.top.mas_equalTo(cashbackTotalAmountTitleLabel.mas_top);
            make.bottom.mas_equalTo(self.cashbackTotalAmountLabel.mas_bottom);
            make.left.mas_equalTo(shadowView.mas_centerX);
        }];
        
        [waitAmountButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
            @strongify(self);
            if (self.waitAmountClickBlock) {
                self.waitAmountClickBlock();
            }
        }];
                
        //第一行分割线
        UIView * firstLineView = [UIView creatViewWithSuperView:shadowView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [firstLineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.top.mas_equalTo(self.cashbackTotalAmountLabel.mas_bottom).offset(11);
            make.height.mas_equalTo(QGLineHeight());
        }];
        
        
        //本月收益预估标题
        UILabel * expectMonthTitleLabel = [UILabel creatLabelWithSuperView:shadowView title:@"本月收益预估(元)" titleFontSize:cashbackTotalAmountTitleLabel.font textColor:cashbackTotalAmountTitleLabel.textColor alignment:NSTextAlignmentLeft];
        [expectMonthTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.height.mas_equalTo(cashbackTotalAmountTitleLabel);
            make.top.mas_equalTo(firstLineView.mas_bottom).offset(15);
        }];
        
        //本月收益预估金额
        self.expectMonthAmountLabel = [UILabel creatLabelWithSuperView:shadowView title:nil titleFontSize:self.cashbackTotalAmountLabel.font textColor:self.cashbackTotalAmountLabel.textColor alignment:NSTextAlignmentLeft];
        [self.expectMonthAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.height.mas_equalTo(self.cashbackTotalAmountLabel);
            make.top.mas_equalTo(expectMonthTitleLabel.mas_bottom).offset(4);
        }];
        
        //今日消费预估标题
        UILabel * expectTodayTitleLabel = [UILabel creatLabelWithSuperView:shadowView title:@"今日收益预估(元)" titleFontSize:cashbackWaitAmountTitleLabel.font textColor:cashbackWaitAmountTitleLabel.textColor alignment:NSTextAlignmentLeft];
        [expectTodayTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
           make.left.height.mas_equalTo(cashbackWaitAmountTitleLabel);
           make.top.mas_equalTo(firstLineView.mas_bottom).offset(15);
        }];
        
        //今日消费预估金额
        self.expectTodayAmountLabel = [UILabel creatLabelWithSuperView:shadowView title:nil titleFontSize:self.cashbackWaitAmountLabel.font textColor:self.cashbackWaitAmountLabel.textColor alignment:NSTextAlignmentLeft];
        [self.expectTodayAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.height.mas_equalTo(self.cashbackWaitAmountLabel);
            make.top.mas_equalTo(self.expectMonthAmountLabel);
        }];
        
        //第二条线
        UIView * secondLineView = [UIView creatViewWithSuperView:shadowView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [secondLineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.height.mas_equalTo(firstLineView);
            make.top.mas_equalTo(self.expectTodayAmountLabel.mas_bottom).offset(7);
        }];
        
        //上月收益预估标题
        UILabel * expectLastMonthTitleLabel = [UILabel creatLabelWithSuperView:shadowView title:@"上月收益预估(元)" titleFontSize:cashbackTotalAmountTitleLabel.font textColor:cashbackTotalAmountTitleLabel.textColor alignment:NSTextAlignmentLeft];
        [expectLastMonthTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.height.mas_equalTo(cashbackTotalAmountTitleLabel);
            make.top.mas_equalTo(secondLineView.mas_bottom).offset(9);
        }];
        
        //上月收益预估金额
        self.expectLastMonthAmountLabel = [UILabel creatLabelWithSuperView:shadowView title:nil titleFontSize:self.cashbackTotalAmountLabel.font textColor:self.cashbackTotalAmountLabel.textColor alignment:NSTextAlignmentLeft];
        [self.expectLastMonthAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.height.mas_equalTo(self.cashbackTotalAmountLabel);
            make.top.mas_equalTo(expectLastMonthTitleLabel.mas_bottom).offset(4);
        }];
        
        //上月结算预估标题
        UILabel * paidLastMonthTitleLabel = [UILabel creatLabelWithSuperView:shadowView title:@"上月结算预估(元)" titleFontSize:cashbackWaitAmountTitleLabel.font textColor:cashbackWaitAmountTitleLabel.textColor alignment:NSTextAlignmentLeft];
        [paidLastMonthTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.height.mas_equalTo(cashbackWaitAmountTitleLabel);
            make.top.mas_equalTo(expectLastMonthTitleLabel);
        }];
        
        //上月结算预估金额
        self.paidLastMonthAmountLabel = [UILabel creatLabelWithSuperView:shadowView title:nil titleFontSize:self.cashbackWaitAmountLabel.font textColor:self.cashbackWaitAmountLabel.textColor alignment:NSTextAlignmentLeft];
        [self.paidLastMonthAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.height.mas_equalTo(self.cashbackWaitAmountLabel);
            make.top.mas_equalTo(self.expectLastMonthAmountLabel);
        }];
        
        
    }
    return self;
}


- (void)setDataSourceModel:(QGCashbackDataSourceModel *)dataSourceModel
{
    if (_dataSourceModel != dataSourceModel) {
        _dataSourceModel = dataSourceModel;
        
        self.cashbackAmountLabel.text = dataSourceModel.balanceReturnCashAmount;
        self.cashbackTotalAmountLabel.text = dataSourceModel.returnCashTotalAmount;
        self.cashbackWaitAmountLabel.text = dataSourceModel.waitReturnCashAmount;
        self.expectMonthAmountLabel.text = dataSourceModel.expectMonthAmount;
        self.expectTodayAmountLabel.text = dataSourceModel.expectTodayAmount;
        self.expectLastMonthAmountLabel.text = dataSourceModel.expectLastMonthAmount;
        self.paidLastMonthAmountLabel.text = dataSourceModel.paidLastMonthAmount;
        
    }
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
