//
//  QGCashbackBrokenLineCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/12.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCashbackBrokenLineCell.h"

#import "QGBasicUITool.h"
#import "QGDatePickerView.h"
#import "QGCalendarManager.h"
#import "QGBrokenLineView.h"
@interface QGCashbackBrokenLineCell ()

/// 月份按钮
@property (nonatomic, strong) UIButton * monthButton;

/// 折线图
@property (nonatomic, strong) QGBrokenLineView * brokenLineView;

/// 年索引
@property (nonatomic, assign) NSInteger yearIndex;

/// 月份索引
@property (nonatomic, assign) NSInteger monthIndex;

/// 选择的月份信息，用于请求新月份的数据
@property (nonatomic, strong) NSNumber * selectDateSince1970;
@end


@implementation QGCashbackBrokenLineCell



- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //返现报表
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"返现报表" titleFontSize:[UIFont qg_mediumFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(20);
            make.top.inset(5);
            make.height.mas_equalTo(25);
        }];
        
        //月份按钮
        self.monthButton = [UIButton creatButtonWithSuperView:self.contentView title:@"本月" titleFont:[UIFont qg_regularFontOfSize:11] textColor:[UIColor textColor3333]];
        self.monthButton.backgroundColor = [UIColor moduleSeparatorColorF7F7];
        self.monthButton.layer.cornerRadius = 10;
        self.monthButton.clipsToBounds = YES;
        [self.monthButton setImage:[UIImage imageNamed:@"cashback_brokenline_month_arrow"] forState:UIControlStateNormal];
        
        [self.monthButton setImageEdgeInsets:UIEdgeInsetsMake(0, 24, 0, -24)];
        [self.monthButton setTitleEdgeInsets:UIEdgeInsetsMake(0, -8, 0, 8)];
        
        [self.monthButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(51, 20));
            make.right.inset(20);
            make.centerY.mas_equalTo(titleLabel);
        }];
        [self.monthButton addTarget:self action:@selector(monthButtonClick) forControlEvents:UIControlEventTouchUpInside];
        
        //折线图
        self.brokenLineView = [[QGBrokenLineView alloc] initWithFrame:CGRectMake(0, 5 + 20 + 30, MAINSCREEN_WIDTH, BrokenLineViewHeigh)];
        [self.contentView addSubview:self.brokenLineView];
        @weakify(self);
        self.brokenLineView.bubbleClickBlock = ^(QGCashbackBrokenLineModel * _Nonnull brokenLineModel) {
            @strongify(self);
            if (self.bubbleClickBlock) {
                self.bubbleClickBlock(brokenLineModel);
            }
        };
    
    }
    return self;
}


#pragma mark - Action
- (void)monthButtonClick
{
    if (self.dataSourceModel.yearArray.count == 0) {
        [QGHUDManager showHud:@"未找到年份信息"];
        return;
    }
    
    //如果没有选中的数据，则需要设置选中日期（年月）的索引
    if (!self.selectDateSince1970) {
        QGCalendarManager * calendar = [QGCalendarManager shareInstance];
        NSString * year = [calendar getStringFromDate:self.dataSourceModel.currentMonthDate formatter:@"yyyy"];
        NSString * month = [calendar getStringFromDate:self.dataSourceModel.currentMonthDate formatter:@"MM"];
        //判断年是否存在
        if ([self.dataSourceModel.yearArray containsObject:year]) {
            self.yearIndex = [self.dataSourceModel.yearArray indexOfObject:year];
            NSArray * monthArray = self.dataSourceModel.monthForYearDic[year];
            //判断年对应的月是否存在
            if (monthArray && [monthArray containsObject:month]) {
                self.monthIndex = [monthArray indexOfObject:month];
            }
        }
    }
    
    //调起pickView
    QGDatePickerView * pickerView = [[QGDatePickerView alloc] initWithYearsArray:self.dataSourceModel.yearArray monthDic:self.dataSourceModel.monthForYearDic];
    [pickerView setFirstIndex:self.yearIndex secondIndex:self.monthIndex];
    [pickerView showInView:nil];
    
    @weakify(self);
    pickerView.doneBlock = ^(NSInteger yearIndex, NSInteger monthIndex) {
        @strongify(self);
        self.yearIndex = yearIndex;
        self.monthIndex = monthIndex;
        [self selectMonthDone];
    };
}


/// 月份选择完成
- (void)selectMonthDone
{
    NSString * yearStr = self.dataSourceModel.yearArray[self.yearIndex];
    NSArray * monthArray = self.dataSourceModel.monthForYearDic[yearStr];
    NSString * monthStr = monthArray[self.monthIndex];
    if (![NSString isEmpty:yearStr] && ![NSString isEmpty:monthStr]) {
        //选中的日期 yyyyMM
        NSString * selectDateStr = [yearStr stringByAppendingString:monthStr];
        QGCalendarManager * calendar = [QGCalendarManager shareInstance];
        NSDate * selectDate = [calendar getDateFromString:selectDateStr formatter:@"yyyyMM"];
        self.dataSourceModel.selectMonthDate = selectDate;
        //转换成时间戳，给到后台
        NSNumber * selectDateSince1970 = @([selectDate timeIntervalSince1970]);
        NSDate * currentMonthDate = self.dataSourceModel.currentMonthDate;
        //如果比对一致，就是本月
        if ([calendar date:selectDate isEqualMonthAnother:currentMonthDate]) {
            [self.monthButton setTitle:@"本月" forState:UIControlStateNormal];
        }
        else
        {
            [self.monthButton setTitle:[NSString stringWithFormat:@"%@月",monthStr] forState:UIControlStateNormal];
        }
        self.selectDateSince1970 = selectDateSince1970;
        
        //选择月份回调
        if (self.monthSelectBlock) {
            self.monthSelectBlock(self.selectDateSince1970);
        }
        
    }
    else
    {
        [QGHUDManager showHud:@"日期选择异常"];
    }
}




#pragma mark - Setter
- (void)setDataSourceModel:(QGCashbackDataSourceModel *)dataSourceModel
{
    if (_dataSourceModel != dataSourceModel) {
        _dataSourceModel = dataSourceModel;
        //第一次的时候需要置为本月
        [self.monthButton setTitle:@"本月" forState:UIControlStateNormal];
    }
    
    [self.brokenLineView setSelectMonth:dataSourceModel.selectMonthDate returnCashList:dataSourceModel.returnCashList today:dataSourceModel.currentMonthDate];
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
