//
//  QGCashbackBrokenLineCell.h
//  VirtualPayment
//
//  Created by 张博 on 2020/3/12.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "QGCashbackDataSourceModel.h"
NS_ASSUME_NONNULL_BEGIN

///折线图选择的月份回调
typedef void(^QGCashbackBrokenLineMonthSelectBlock)(NSNumber * selectMonthSince1970);

///折线图气泡点击事件
typedef void(^QGCashbackBrokenLineBubbleClickBlock)(QGCashbackBrokenLineModel * brokenLineModel);

@interface QGCashbackBrokenLineCell : UITableViewCell

/// 月份选择回调
@property (nonatomic, copy) QGCashbackBrokenLineMonthSelectBlock monthSelectBlock;

/// 气泡点击事件
@property (nonatomic, copy) QGCashbackBrokenLineBubbleClickBlock bubbleClickBlock;

/// 返现折线图
@property (nonatomic, strong) QGCashbackDataSourceModel * dataSourceModel;

@end

NS_ASSUME_NONNULL_END
