//
//  QGBrokenLineView.h
//  VirtualPayment
//
//  Created by 张博 on 2020/3/13.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "QGCashbackDataSourceModel.h"
#import "QGAppMacro.h"
@class QGBrokenLineDayModel;

///整个视图的高度
#define BrokenLineViewHeigh 160
///折线图展示区域高度
#define BrokenLineContentHeight 120
///气泡的高度
#define BrokenLineBubbleHeight 40
///折线图每一个小块的宽度
#define BrokenLineSubViewWidth (MAINSCREEN_WIDTH/7.0)

NS_ASSUME_NONNULL_BEGIN

///折线图气泡点击事件
typedef void(^QGBrokenLineViewBubbleClickBlock)(QGCashbackBrokenLineModel * brokenLineModel);

@interface QGBrokenLineView : UIView

/// 折线图气泡点击事件
@property (nonatomic, copy) QGBrokenLineViewBubbleClickBlock bubbleClickBlock;

/// 设置选择的月份、数据源、今天的日期
/// @param selectMonth 当前选择的月份
/// @param returnCashList 折线图数据源
/// @param today 今天的日期
- (void)setSelectMonth:(NSDate *)selectMonth returnCashList:(NSArray *)returnCashList today:(NSDate *)today;


@end


/// 折线图子视图
@interface QGBrokenLineSubView : UICollectionViewCell
/// 右侧线条
@property (nonatomic, strong) UIView * rightLineView;

/// 每日的数据
@property (nonatomic, strong) QGBrokenLineDayModel * dayModel;

@end

NS_ASSUME_NONNULL_END
