//
//  QGBrokenLineBubbleView.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/16.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBrokenLineBubbleView.h"
#import "QGBasicUITool.h"

@interface QGBrokenLineBubbleView ()

/// 标题文案
@property (nonatomic, strong) UILabel * titleLabel;

@end

@implementation QGBrokenLineBubbleView

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        //背景
        UIView * bgView = [UIView creatViewWithSuperView:self backgroundColor:[UIColor colorWithHexString:@"EBB45F"]];
        bgView.userInteractionEnabled = NO;
        bgView.layer.cornerRadius = 3;
        
        [bgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.top.right.inset(0);
            make.height.mas_equalTo(26);
        }];
        
        //向下箭头
        UIImageView * bottomArrowImg = [UIImageView creatImageViewWithSuperView:self imageName:@"cashback_bubble_bottom"];
        [bottomArrowImg mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(11, 5));
            make.top.mas_equalTo(bgView.mas_bottom).offset(-1);
            make.centerX.mas_equalTo(self);
        }];
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:bgView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:13] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.bottom.inset(4);
            make.left.right.inset(0);
        }];
        
        //选中的小红点
        UIImageView * pointImgView = [UIImageView creatImageViewWithSuperView:self imageName:@"cashback_point_select"];
        [pointImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(19, 19));
            make.centerX.offset(0);
            make.centerY.mas_equalTo(self.mas_bottom);
        }];
    }
    return self;
}

#pragma mark - Setter
- (void)setDayModel:(QGBrokenLineDayModel *)dayModel
{
    if (_dayModel != dayModel) {
        _dayModel = dayModel;
        
        self.titleLabel.attributedText = _dayModel.bubbleTitleStr;
    }
}

@end
