//
//  QGCashbackDataSourceModel.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/11.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCashbackDataSourceModel.h"
#import "QGCalendarManager.h"
@implementation QGCashbackDataSourceModel


+ (NSDictionary *)modelContainerPropertyGenericClass {
    return @{@"returnCashActivityBannerList" : [QGCashbackBannerModel class],
             @"returnCashRuleBannerList" : [QGCashbackBannerModel class],
             @"returnCashList" : [QGCashbackBrokenLineModel class],
             @"returnCashReport" : [QGCashbackCategoryModel class]
            };
}

+ (NSArray *)modelPropertyBlacklist {
    return @[@"yearArray", @"monthForYearDic",@"currentMonthDate",@"selectMonthDate"];
}


- (NSDate *)selectMonthDate
{
    if (!_selectMonthDate && self.returnCashMonth.length > 0) {
        //第一次以后台返回的当前月初始化
        _selectMonthDate = [NSDate dateWithTimeIntervalSince1970:self.returnCashMonth.doubleValue];
    }
    return _selectMonthDate;
}

- (NSDate *)currentMonthDate
{
    if (!_currentMonthDate && self.returnCashMonth.length > 0) {
        _currentMonthDate = [NSDate dateWithTimeIntervalSince1970:self.returnCashMonth.doubleValue];
    }
    return _currentMonthDate;
}

- (NSArray *)yearArray
{
    if (!_yearArray && self.returnCashMonthMin.length > 0 && self.returnCashMonthMax.length > 0) {
        [self resetBrokenLinerAndMonthDataSource];
    }
    return _yearArray;
}


- (NSDictionary *)monthForYearDic
{
    if (!_monthForYearDic  && self.returnCashMonthMin.length > 0 && self.returnCashMonthMax.length > 0) {
        [self resetBrokenLinerAndMonthDataSource];
    }
    return _monthForYearDic;
}

/// 重置折线图年月数据
- (void)resetBrokenLinerAndMonthDataSource
{
    NSDate * fromDate = [NSDate dateWithTimeIntervalSince1970:self.returnCashMonthMin.doubleValue];
    NSDate * toDate = [NSDate dateWithTimeIntervalSince1970:self.returnCashMonthMax.doubleValue];
    NSDictionary * yearAndMonthDic = [[QGCalendarManager shareInstance] getYearsAndMonthsFromDate:fromDate toDate:toDate];
    //对年进行从小到大排序
    //yes升序排列，no,降序排列
    NSSortDescriptor * sort = [NSSortDescriptor sortDescriptorWithKey:nil ascending:YES];
    NSArray * descendingDateArr = [yearAndMonthDic.allKeys sortedArrayUsingDescriptors:[NSArray arrayWithObjects:sort, nil]];
    _yearArray = descendingDateArr;
    _monthForYearDic = yearAndMonthDic;
}



@end

@implementation QGCashbackBannerModel



@end


@implementation QGCashbackBrokenLineModel

+ (NSArray *)modelPropertyBlacklist {
    return @[@"monthAndDayTime"];
}


- (NSString *)monthAndDayTime
{
    if (_monthAndDayTime.length == 0 && self.returnCashTime.length > 0) {
        NSDate * date = [NSDate dateWithTimeIntervalSince1970:self.returnCashTime.doubleValue];
        _monthAndDayTime = [[QGCalendarManager shareInstance] getStringFromDate:date formatter:@"M-d"];
    }
    return _monthAndDayTime;
}

@end

@implementation QGCashbackCategoryModel



@end
