//
//  QGCashbackDataSourceModel.h
//  VirtualPayment
//
//  Created by 张博 on 2020/3/11.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBaseModel.h"
#import "QGCashbackUserInfoModel.h"
NS_ASSUME_NONNULL_BEGIN
@class QGCashbackBannerModel, QGCashbackBrokenLineModel, QGCashbackCategoryModel;

@interface QGCashbackDataSourceModel : QGBaseModel

/// 返现余额
@property (nonatomic, strong) NSString * balanceReturnCashAmount;

/// 当前返现月份，时间戳
@property (nonatomic, strong) NSString * returnCashMonth;

/// 最大月份，时间戳
@property (nonatomic, strong) NSString * returnCashMonthMax;

/// 最小月份，时间戳
@property (nonatomic, strong) NSString * returnCashMonthMin;

/// 返现总笔数
@property (nonatomic, strong) NSString * returnCashReportTotal;

/// 返现总金额
@property (nonatomic, strong) NSString * returnCashReportTotalAmount;

/// 累计返现明细URL
@property (nonatomic, strong) NSString * returnCashTotalUrl;

/// 累计返现金额
@property (nonatomic, strong) NSString * returnCashTotalAmount;

/// 待返现金额
@property (nonatomic, strong) NSString * waitReturnCashAmount;

/// 待返现明细URL
@property (nonatomic, strong) NSString * waitReturnCashUrl;

/// 返现活动banner
@property (nonatomic, strong) NSArray <QGCashbackBannerModel *> * returnCashActivityBannerList;

/// 返现攻略banner
@property (nonatomic, strong) NSArray <QGCashbackBannerModel *> * returnCashRuleBannerList;

/// 返现折线图
@property (nonatomic, strong) NSArray <QGCashbackBrokenLineModel *> * returnCashList;

/// 返现分类
@property (nonatomic, strong) NSArray <QGCashbackCategoryModel *> * returnCashReport;

/// 用户信息
@property (nonatomic, strong) QGCashbackUserInfoModel * userInfo;

/// 本月收益预估金额
@property (nonatomic, strong) NSString * expectMonthAmount;

/// 上月收益预估金额
@property (nonatomic, strong) NSString * expectLastMonthAmount;

/// 今日收益预估
@property (nonatomic, strong) NSString * expectTodayAmount;

/// 上月结算预估
@property (nonatomic, strong) NSString * paidLastMonthAmount;

/// 推广链接
@property (nonatomic, strong) NSString * promoterUrl;



/***********以下为自定义属性***********/

/// 折线图可选的年范围
@property (nonatomic, strong) NSArray * yearArray;

/// 折线图可选年范围内对应的月数组
@property (nonatomic, strong) NSDictionary * monthForYearDic;

/// 当前月份日期 （年月日，此处为后台当天的时间戳转换）
@property (nonatomic, strong) NSDate * currentMonthDate;

/// 用户选中的月份日期 第一次为后台返回的当前月份
@property (nonatomic, strong) NSDate * selectMonthDate;

@end




/// banner数组模型
@interface QGCashbackBannerModel : QGBaseModel

/// 图标
@property (nonatomic, strong) NSString * img;

/// 跳转地址
@property (nonatomic, strong) NSString * jumpUrl;

/// 标题
@property (nonatomic, strong) NSString * name;

/// 是否需要登录
@property (nonatomic, strong) NSString * needLogin;
@end


/// 折线图
@interface QGCashbackBrokenLineModel : QGBaseModel

/// 返现金额
@property (nonatomic, strong) NSString * returnCashAmount;

/// 返现日期，时间戳
@property (nonatomic, strong) NSString * returnCashTime;

/// 返现明细URL
@property (nonatomic, strong) NSString * returnCashUrl;

/// 返现日期 月-日类型
@property (nonatomic, strong) NSString * monthAndDayTime;

@end


/// 返现分类
@interface QGCashbackCategoryModel : QGBaseModel

/// 返现金额
@property (nonatomic, strong) NSString * returnCashAmount;

/// 返现占比，“0.99”
@property (nonatomic, strong) NSString * returnCashPerc;

/// 返现类型，1消费返现，2购物返现，3分享返现，4活动返现
@property (nonatomic, strong) NSString * returnCashType;

/// 返现类型描述
@property (nonatomic, strong) NSString * returnCashTypeDesc;

/// 返现图标
@property (nonatomic, strong) NSString * returnCashTypeImg;

/// 返现明细URL
@property (nonatomic, strong) NSString * returnCashUrl;

@end
NS_ASSUME_NONNULL_END
