//
//  QGBrokenLineMonthModel.h
//  VirtualPayment
//
//  Created by 张博 on 2020/3/13.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBaseModel.h"
#import "QGCashbackDataSourceModel.h"
@class QGBrokenLineDayModel;
NS_ASSUME_NONNULL_BEGIN

@interface QGBrokenLineMonthModel : QGBaseModel

/// 年
@property (nonatomic, strong) NSString * year;

/// 月
@property (nonatomic, strong) NSString * month;

/// 日模型数组
@property (nonatomic, strong) NSMutableArray<QGBrokenLineDayModel *> * dayArray;

/// 一月的天数
@property (nonatomic, assign) NSInteger daysNum;

@end


/// 每日的日期模型
@interface QGBrokenLineDayModel : NSObject

/// 日期
@property (nonatomic, strong) NSDate * date;

@property (nonatomic, strong) NSString * year;

@property (nonatomic, strong) NSString * month;

@property (nonatomic, strong) NSString * day;

/// 是否是今天
@property (nonatomic, assign) BOOL isToday;

/// M-d
@property (nonatomic, strong) NSString * monthAndDay;

/// 与之匹配的折线图信息
@property (nonatomic, strong) QGCashbackBrokenLineModel * brokenLineModel;

/// 日期点的位置
@property (nonatomic, assign) CGPoint point;

/// 是否被选中
@property (nonatomic, assign) BOOL isSelect;

/// 气泡展示的标题
@property (nonatomic, strong) NSAttributedString * bubbleTitleStr;

@end

NS_ASSUME_NONNULL_END
