//
//  QGMembershipCenterViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/27.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMembershipCenterViewController.h"


//View
#import "QGMembershipHeaderCell.h"
#import "QGMembershipNotificationCell.h"
#import "QGMembershipProfitCell.h"
#import "QGMembershipTaskCell.h"
#import "QGMembershipMoreCell.h"

//Tool
#import "QGCashbackRequestApi.h"
#import "QGApplicationOpenURL.h"
#import "ZHWeChatTool.h"

//Model
#import "QGMembershipCenterDataModel.h"

@interface QGMembershipCenterViewController ()

/// 会员中心数据源
@property (nonatomic, strong) QGMembershipCenterDataModel * dataModel;

@end

@implementation QGMembershipCenterViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

- (UIStatusBarStyle)preferredStatusBarStyle
{
    return UIStatusBarStyleLightContent;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    [self initNormalUI];
    [self requestData];
}

- (void)initNormalUI
{
    [self custemLeftWhiteBarButtonItem];
    [self setNavBarBottomLineHidden:YES];
    [self setNavBarBackgroundAlpha:0];
    self.isBelowNavBar = YES;
    [self setupNavBarTitleColor:[UIColor whiteColor] title:@"会员中心"];
    [self setNavBarBackgroundColor:[UIColor colorWithHexString:@"2D2323"]];
    self.tableView.backgroundColor = [UIColor colorWithHexString:@"2D2323"];
}

#pragma mark - Request
- (void)requestData
{
    NSString * urlString = [QGCashbackRequestApi urlWithIndex:QGCashbackRequestServerMethodPromoterCenter];
//    urlString = @"http://yapi.quantgroups.com/mock/305/vcc/app/promoter/index";
    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        //请求成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            self.dataModel = [QGMembershipCenterDataModel yy_modelWithDictionary:responseObject[@"data"]];
            [self.tableView reloadData];
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
}


#pragma mark - UITableViewDataSource

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    //个人信息 | 通知 | 权益 | 升级任务 | 更多福利
    return self.dataModel ? 5 : 0;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger numberOfRows = 1;
    switch (section) {
            //通知
        case 1:
            numberOfRows = self.dataModel.noticeList.count > 0 ? 1 : 0;
            break;
            //权益
        case 2:
            numberOfRows = self.dataModel.profitList.count;
            break;
            //升级任务
        case 3:
            numberOfRows = self.dataModel.promoterTask.taskList.count;
            break;
            //更多福利特权
        case 4:
            numberOfRows = self.dataModel.moreProfit ? 1 : 0;
            break;
        default:
            break;
    }
    return numberOfRows;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell * resultCell;
    
    @weakify(self);
    switch (indexPath.section) {
            //顶部
        case 0:
        {
            QGMembershipHeaderCell * cell = (QGMembershipHeaderCell *)[self getCellFromClassName:NSStringFromClass([QGMembershipHeaderCell class]) dequeueTableView:tableView];
            
            cell.userInfoModel = self.dataModel.userInfo;
            resultCell = cell;
 
        }
            break;
            //通知
        case 1:
        {
            QGMembershipNotificationCell * cell = (QGMembershipNotificationCell *)[self getCellFromClassName:NSStringFromClass([QGMembershipNotificationCell class]) dequeueTableView:tableView];
            cell.notificationArray = self.dataModel.noticeList;
            resultCell = cell;
            
            //公告点击事件
            cell.clickBlock = ^(NSInteger index) {
                @strongify(self);
                [self notificationClick:index];
            };
            
        }
            break;
            //权益
        case 2:
        {
            QGMembershipProfitCell * cell = (QGMembershipProfitCell *)[self getCellFromClassName:NSStringFromClass([QGMembershipProfitCell class]) dequeueTableView:tableView];
            cell.profitModel = self.dataModel.profitList[indexPath.row];
            resultCell = cell;
            
            //子权益
            cell.clickBlock = ^(NSInteger index) {
                @strongify(self);
                [self subProfitClickBlock:index indexRow:indexPath.row];
            };
        }
            break;
            //升级任务
        case 3:
        {
            QGMembershipTaskCell * cell = (QGMembershipTaskCell *)[self getCellFromClassName:NSStringFromClass([QGMembershipTaskCell class]) dequeueTableView:tableView];
            QGMembershipSubTaskModel * subTaskModel = self.dataModel.promoterTask.taskList[indexPath.row];
            cell.subTaskModel = subTaskModel;
            resultCell = cell;
            
            [cell.taskButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
                @strongify(self);
                [self taskButtonClickWithTaskModel:subTaskModel];
            }];
            
        }
            break;
            //更多福利特权
        case 4:
        {
            QGMembershipMoreCell * cell = (QGMembershipMoreCell *)[self getCellFromClassName:NSStringFromClass([QGMembershipMoreCell class]) dequeueTableView:tableView];
            cell.moreModel = self.dataModel.moreProfit;
            resultCell = cell;
            
            //复制微信并且跳转微信
            [cell.openWechatButton addTarget:self action:@selector(openWechatButtonClick) forControlEvents:UIControlEventTouchUpInside];
        }
            break;
        default:
            break;
    }
    
    
    
    
    return resultCell ? resultCell : [UITableViewCell new];
}

#pragma mark - UITableViewDelegate
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CGFloat heightForRow = 0;
    switch (indexPath.section) {
            //顶部
        case 0:
            heightForRow = 100 + [DeviceAdaptation getNavBarAndStatusBarHeight];
            break;
            //通知
        case 1:
            heightForRow = 26;
            break;
            //权益
        case 2:
        {
            QGMembershipProfitModel * subModel = self.dataModel.profitList[indexPath.row];
            heightForRow = subModel.profitCellHeight;
        }
            break;
            //升级任务
        case 3:
            heightForRow = 62;
            break;
            //更多福利特权
        case 4:
            heightForRow = 210;
            break;
        default:
            break;
    }
    return heightForRow;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    //升级任务
    if (section == 3 && self.dataModel.promoterTask) {
        return 70;
    }
    return [super tableView:tableView heightForHeaderInSection:section];
}

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    //升级任务
    if (section == 3 && self.dataModel.promoterTask) {
        UIView * headerView = [UIView creatViewWithSuperView:nil backgroundColor:[UIColor clearColor]];
        //标题
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:headerView title:self.dataModel.promoterTask.title titleFontSize:[UIFont qg_mediumFontOfSize:17] textColor:[UIColor colorWithHexString:@"E9B277"] alignment:NSTextAlignmentLeft];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(20);
            make.bottom.inset(20);
            make.height.mas_equalTo(24);
        }];
        
        //副标题
        UILabel * subTitleLabel = [UILabel creatLabelWithSuperView:headerView title:self.dataModel.promoterTask.desc titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor whiteColor] alignment:NSTextAlignmentLeft];
        [subTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(titleLabel.mas_right);
            make.bottom.mas_equalTo(titleLabel);
            make.height.mas_equalTo(17);
        }];
        
        return headerView;
    }
    return nil;
}

#pragma mark - UIScrollViewDelegate
- (void)scrollViewDidScroll:(UIScrollView *)scrollView
{
    CGFloat scrollHeight = 44 + [DeviceAdaptation getNavBarAndStatusBarHeight];
    CGFloat offsetY = scrollView.contentOffset.y;
    CGFloat alpha = MAX(MIN(offsetY/scrollHeight, 1), 0);
    [self setNavBarBackgroundAlpha:alpha];
}

#pragma mark - Action

/// 公告点击事件
- (void)notificationClick:(NSInteger)index
{
    QGNotifyInfoModel * model =  self.dataModel.noticeList[index];
    /// 跳转类型，0不可跳转、1原生、2H5
    switch (model.jumpType.integerValue) {
            //原生
        case 1:
        {
            [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGCardNotificationController) parameters:@{@"infoModel":model} handlerBlock:nil];
        }
            break;
        case 2:
        {
            [self navigationToWeb:model.jumpUrl];
        }
            break;
            
        default:
            break;
    }
}

///子权益点击事件
- (void)subProfitClickBlock:(NSInteger)index indexRow:(NSInteger)indexRow
{
    QGMembershipProfitModel * profitModel = self.dataModel.profitList[indexRow];
    QGMembershipSubProfitModel * subProfit = profitModel.subProfitList[index];
    
    //神策埋点
    QGAppCoreModelClickEvent * clickEvent = [QGAppCoreModelClickEvent acmcEventWithPage:@"会员中心" path:profitModel.title name:subProfit.title detail_name:nil acmc_model_other:self.dataModel.userInfo.promoterLevel];
    [QGAnalyticsService analyticsTrackWithEvent:clickEvent];
    
    if (![NSString isEmpty:subProfit.jumpUrl]) {
        [QGApplicationOpenURL handleAllSupportUrl:subProfit.jumpUrl];
    }
}

/// 升级任务点击事件
- (void)taskButtonClickWithTaskModel:(QGMembershipSubTaskModel *)subTaskModel
{
    if (![NSString isEmpty:subTaskModel.jumpUrl]) {
        [QGApplicationOpenURL handleAllSupportUrl:subTaskModel.jumpUrl];
        
        //神策埋点
        QGAppCoreModelClickEvent * clickEvent = [QGAppCoreModelClickEvent acmcEventWithPage:@"会员中心" path:@"升级任务" name:subTaskModel.jumpDesc detail_name:nil acmc_model_other:self.dataModel.userInfo.promoterLevel];
        [QGAnalyticsService analyticsTrackWithEvent:clickEvent];
    }
}

///复制小姐姐微信号并且跳转微信
- (void)openWechatButtonClick
{
    UIPasteboard * paste = [UIPasteboard generalPasteboard];
    paste.string = self.dataModel.moreProfit.wechat;
    paste.strings = @[self.dataModel.moreProfit.wechat];
    //安装微信则跳转
    if ([[ZHWeChatTool share] isWXInstalled]) {
        [QGHUDManager showHud:@"微信号已复制"];
        //延时调用打开微信
        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(1.5 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
            [[ZHWeChatTool share] openWXApp];
        });
    }
    else
    {
        [QGHUDManager showHud:@"未安装微信"];
    }
    
    
    //神策埋点
    QGAppCoreModelClickEvent * clickEvent = [QGAppCoreModelClickEvent acmcEventWithPage:@"会员中心" path:@"更多福利" name:@"添加运营小姐姐" detail_name:nil acmc_model_other:self.dataModel.userInfo.promoterLevel];
    [QGAnalyticsService analyticsTrackWithEvent:clickEvent];

}

@end
