//
//  QGMembershipProfitCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/28.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMembershipProfitCell.h"
#import "QGBasicUITool.h"
#import "UIImageView+QGWebCache.h"
@interface QGMembershipProfitCell ()<UICollectionViewDelegate, UICollectionViewDataSource>

/// 标题
@property (nonatomic, strong) UILabel * titleLabel;

/// 子权益承载视图
@property (nonatomic, strong) UICollectionView * collectionView;


@end


@implementation QGMembershipProfitCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        self.backgroundColor = [UIColor clearColor];
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:17] textColor:[UIColor colorWithHexString:@"E9B176"] alignment:NSTextAlignmentLeft];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(20);
            make.top.inset(25);
            make.height.mas_equalTo(24);
        }];
        
        //权益承载
        UICollectionViewFlowLayout * flowLayout = [[UICollectionViewFlowLayout alloc] init];
        flowLayout.scrollDirection = UICollectionViewScrollDirectionVertical;
        flowLayout.sectionInset = UIEdgeInsetsMake(14, 0, 14, 0);
        flowLayout.minimumLineSpacing = 0;
        flowLayout.minimumInteritemSpacing = 0;
        flowLayout.itemSize = CGSizeMake((MAINSCREEN_WIDTH - 20 * 2)/2.0, 64);
        self.collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:flowLayout];
        self.collectionView.delegate = self;
        self.collectionView.dataSource = self;
        self.collectionView.backgroundColor = [[UIColor whiteColor] colorWithAlphaComponent:0.1];
        self.collectionView.scrollEnabled = NO;
        [self.contentView addSubview:self.collectionView];
        self.collectionView.layer.cornerRadius = 6;
        self.collectionView.clipsToBounds = YES;
        [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(self.titleLabel.mas_bottom).offset(15);
            make.bottom.inset(5);
            make.left.right.inset(20);
        }];
        
        [self.collectionView registerClass:[QGSubProfitCollectionCell class] forCellWithReuseIdentifier:NSStringFromClass([QGSubProfitCollectionCell class])];
        
    }
    return self;
}

#pragma mark - UICollectionViewDataSource
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.profitModel.subProfitList.count;
}

- (UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGSubProfitCollectionCell * cell = (QGSubProfitCollectionCell *)[collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([QGSubProfitCollectionCell class]) forIndexPath:indexPath];
    cell.subProfitModel = self.profitModel.subProfitList[indexPath.row];
    return cell;
}

#pragma mark - UICollectionViewDelegate
- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    if (self.clickBlock) {
        self.clickBlock(indexPath.row);
    }
}


#pragma mark - Setter
- (void)setProfitModel:(QGMembershipProfitModel *)profitModel
{
    if (_profitModel != profitModel) {
        _profitModel = profitModel;
        [self.collectionView reloadData];
        self.titleLabel.text = _profitModel.title;
    }
}


@end


@interface QGSubProfitCollectionCell ()

/// 大图标
@property (nonatomic, strong) UIImageView * iconImgView;

/// 标题
@property (nonatomic, strong) UILabel * titleLabel;

/// 详情
@property (nonatomic, strong) UILabel * descLabel;

/// 小标识
@property (nonatomic, strong) UIImageView * flagImgView;

@end

@implementation QGSubProfitCollectionCell

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //大图标
        self.iconImgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.iconImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(35, 35));
            make.left.inset(20);
            make.centerY.offset(0);
        }];
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:14] textColor:[UIColor whiteColor] alignment:NSTextAlignmentLeft];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.iconImgView.mas_right).offset(8);
            make.top.inset(12);
            make.height.mas_equalTo(20);
        }];
        
        //详情
        self.descLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor whiteColor] alignment:NSTextAlignmentLeft];
        [self.descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.titleLabel);
            make.top.mas_equalTo(self.titleLabel.mas_bottom).offset(0);
            make.height.mas_equalTo(17);
        }];
        
        //小标识
        self.flagImgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.flagImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(16, 16));
            make.centerY.mas_equalTo(self.titleLabel);
            make.left.mas_equalTo(self.titleLabel.mas_right).offset(1);
        }];
        
    }
    return self;
}

- (void)setSubProfitModel:(QGMembershipSubProfitModel *)subProfitModel
{
    if (_subProfitModel != subProfitModel) {
        _subProfitModel = subProfitModel;
        
        [self.iconImgView setMallImageByNomalPlaceholderWithURLString:subProfitModel.img];
        self.titleLabel.text = subProfitModel.title;
        self.descLabel.text = subProfitModel.subTitle;
        [self.flagImgView setMallImageByNomalPlaceholderWithURLString:subProfitModel.icon];
        self.flagImgView.hidden = [NSString isEmpty:subProfitModel.icon];
        
    }
}

@end
