//
//  QGMembershipMoreCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/28.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMembershipMoreCell.h"

#import "QGGradientShadowButton.h"
#import "QGBasicUITool.h"
#import "ZHAttributedLabelTool.h"

@interface QGMembershipMoreCell ()

/// 标题
@property (nonatomic, strong) UILabel * titleLabel;

/// 复制微信号打开微信
@property (nonatomic, strong, readwrite) QGGradientShadowButton * openWechatButton;

/// 描述信息
@property (nonatomic, strong) UILabel * descLabel;




@end

@implementation QGMembershipMoreCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        self.backgroundColor = [UIColor clearColor];
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:17] textColor:[UIColor colorWithHexString:@"E9B277"] alignment:NSTextAlignmentLeft];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(20);
            make.top.inset(26);
            make.height.mas_equalTo(24);
        }];
        
        //渐变色按钮
        self.openWechatButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.contentView title:nil textFont:[UIFont qg_regularFontOfSize:17]];
        [self.openWechatButton setTitleColor:[UIColor textColor3333] forState:UIControlStateNormal];
        self.openWechatButton.gradientLayer.colors = [UIColor gradientColorsE9B176ToF2CD8B];
        [self.contentView addSubview:self.openWechatButton];
        [self.openWechatButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.mas_equalTo(self.titleLabel.mas_bottom).offset(30);
            make.height.mas_equalTo(40);
        }];
        
        //描述
        self.descLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:nil textColor:nil alignment:NSTextAlignmentCenter];
        self.descLabel.numberOfLines = 0;
        [self.descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.mas_equalTo(self.openWechatButton.mas_bottom).offset(13);
        }];
        
        
        
    }
    return self;
}


- (void)setMoreModel:(QGMembershipMoreModel *)moreModel
{
    if (_moreModel != moreModel) {
        _moreModel = moreModel;
        
        self.titleLabel.text = moreModel.title;
        [self.openWechatButton setTitle:moreModel.jumpDesc forState:UIControlStateNormal];
        
        NSString * wechatStr = [NSString stringWithFormat:@" 微信号 %@",moreModel.wechat];
        NSString * descAllStr = [moreModel.desc stringByAppendingString:wechatStr];
        
        ZHAttributedLabelTool * descTool = [[ZHAttributedLabelTool alloc] initWithText:descAllStr font:[UIFont qg_lightFontOfSize:12] color:[UIColor whiteColor]];
        [descTool addColor:[UIColor colorWithHexString:@"E9B176"] range:[descAllStr rangeOfString:wechatStr]];
        [descTool addFont:[UIFont qg_mediumFontOfSize:12] range:[descAllStr rangeOfString:wechatStr]];
        self.descLabel.attributedText = [descTool getResultString];
    }
}

@end
