//
//  QGMembershipHeaderCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/28.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMembershipHeaderCell.h"
#import "UIImageView+QGWebCache.h"
#import "QGBasicUITool.h"

@interface QGMembershipHeaderCell ()

/// 头像
@property (nonatomic, strong) UIImageView * avatarImgView;

/// 推广等级
@property (nonatomic, strong) UIImageView * levelNameImgView;

/// 用户名称
@property (nonatomic, strong) UILabel * userNameLabel;

/// 等级勋章
@property (nonatomic, strong) UIImageView * levelIconImgView;

@end

@implementation QGMembershipHeaderCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        self.backgroundColor = [UIColor clearColor];
        
        //背景图
        UIImageView * bgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:@"membership_header_bg"];
        bgView.contentMode = UIViewContentModeScaleAspectFill;
        [bgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.bottom.left.right.inset(0);
        }];
        
        
        //等级勋章
        self.levelIconImgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.levelIconImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.bottom.inset(5);
            make.right.inset(25);
            make.size.mas_equalTo(CGSizeMake(91, 91));
        }];
        
        //头像
        self.avatarImgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.avatarImgView setBorder:[UIColor whiteColor] width:1];
        self.avatarImgView.layer.cornerRadius = 45/2.0;
        self.avatarImgView.clipsToBounds = YES;
        [self.avatarImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(45, 45));
            make.left.inset(20);
            make.bottom.inset(30);
        }];
        
        //推广等级名称
        self.levelNameImgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.levelNameImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.avatarImgView.mas_right).offset(10);
            make.top.mas_equalTo(self.avatarImgView.mas_top).offset(7);
            make.size.mas_equalTo(CGSizeMake(72, 18));
        }];
        
        //推广名称
        self.userNameLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:14] textColor:[UIColor colorWithHexString:@"E9B176"] alignment:NSTextAlignmentLeft];
        [self.userNameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.levelNameImgView);
            make.top.mas_equalTo(self.levelNameImgView.mas_bottom).offset(0);
            make.height.mas_equalTo(20);
        }];
        
        
        
    }
    return self;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

- (void)setUserInfoModel:(QGCashbackUserInfoModel *)userInfoModel
{
    if (_userInfoModel != userInfoModel) {
        _userInfoModel = userInfoModel;
        [self.avatarImgView setImageWithPlaceholder:@"cashback_header_avatar" URLString:userInfoModel.avatar];
        [self.levelNameImgView setMallImageByNomalPlaceholderWithURLString:userInfoModel.promoterLevelDescImg];
        [self.levelIconImgView setMallImageByNomalPlaceholderWithURLString:userInfoModel.promoterLevelImg];
        self.userNameLabel.text = userInfoModel.phoneNo;
    }
}


@end
