//
//  QGMembershipCenterDataModel.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/28.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMembershipCenterDataModel.h"
#import "QGBasicUITool.h"
@implementation QGMembershipCenterDataModel


+ (NSDictionary *)modelContainerPropertyGenericClass {
    return @{@"noticeList" : [QGNotifyInfoModel class],
             @"profitList" : [QGMembershipProfitModel class],
            };
}



@end




/// 权益信息
@implementation QGMembershipProfitModel


+ (NSDictionary *)modelContainerPropertyGenericClass {
    return @{@"subProfitList" : [QGMembershipSubProfitModel class]
            };
}

+ (NSArray *)modelPropertyBlacklist {
    return @[@"profitCellHeight"];
}

- (CGFloat)profitCellHeight
{
    if (_profitCellHeight == 0 && self.subProfitList.count > 0) {
        
        CGFloat subProfitHeight = ceilf(self.subProfitList.count/2.0) * 64;
        _profitCellHeight = 65 + 14 + subProfitHeight + 14 + 5;
    }
    return _profitCellHeight;
}

@end


/// 子权益信息
@implementation QGMembershipSubProfitModel



@end


/// 推广任务
@implementation QGMembershipTaskModel

+ (NSDictionary *)modelContainerPropertyGenericClass {
    return @{@"taskList" : [QGMembershipSubTaskModel class]
            };
}

@end

/// 推广子任务
@implementation QGMembershipSubTaskModel

@end


/// 更多福利
@implementation QGMembershipMoreModel



@end
