//
//  QGMembershipCenterDataModel.h
//  VirtualPayment
//
//  Created by 张博 on 2020/4/28.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBaseModel.h"
#import "QGCashbackUserInfoModel.h"
#import "ZHAttributedLabelTool.h"
#import "QGNotifyInfoModel.h"

NS_ASSUME_NONNULL_BEGIN

@class QGMembershipProfitModel,QGMembershipSubProfitModel,QGMembershipTaskModel,QGMembershipSubTaskModel, QGMembershipMoreModel;

@interface QGMembershipCenterDataModel : QGBaseModel

/// 用户信息
@property (nonatomic, strong) QGCashbackUserInfoModel * userInfo;

/// 公告列表
@property (nonatomic, strong) NSArray <QGNotifyInfoModel *> * noticeList;

/// 权益列表
@property (nonatomic, strong) NSArray <QGMembershipProfitModel *> * profitList;

/// 推广任务
@property (nonatomic, strong) QGMembershipTaskModel * promoterTask;

/// 更多福利
@property (nonatomic, strong) QGMembershipMoreModel * moreProfit;

@end





/// 权益信息
@interface QGMembershipProfitModel : QGBaseModel

/// 权益标题
@property (nonatomic, strong) NSString * title;

/// 子权益列表
@property (nonatomic, strong) NSArray <QGMembershipSubProfitModel *> * subProfitList;

/// 权益列表高度
@property (nonatomic, assign) CGFloat profitCellHeight;

@end


/// 子权益信息
@interface QGMembershipSubProfitModel : QGBaseModel

/// 权益图片
@property (nonatomic, strong) NSString * img;

/// 升级图标
@property (nonatomic, strong) NSString * icon;

/// 权益标题
@property (nonatomic, strong) NSString * title;

/// 子标题
@property (nonatomic, strong) NSString * subTitle;

/// 跳转链接
@property (nonatomic, strong) NSString * jumpUrl;


@end


/// 推广任务
@interface QGMembershipTaskModel : QGBaseModel

/// 推广任务模块名称
@property (nonatomic, strong) NSString * title;

/// 推广任务模块描述
@property (nonatomic, strong) NSString * desc;

/// 任务列表
@property (nonatomic, strong) NSArray <QGMembershipSubTaskModel *> * taskList;

@end

/// 推广子任务
@interface QGMembershipSubTaskModel : QGBaseModel

/// 任务标题
@property (nonatomic, strong) NSString * taskTitle;

/// 百分比
@property (nonatomic, strong) NSString * taskPercent;

/// 任务描述
@property (nonatomic, strong) NSString * taskDesc;

/// 任务提示
@property (nonatomic, strong) NSString * taskTips;

/// 跳转链接
@property (nonatomic, strong) NSString * jumpUrl;

/// 按钮描述
@property (nonatomic, strong) NSString * jumpDesc;
@end


/// 更多福利
@interface QGMembershipMoreModel : QGBaseModel

/// 更多福利特权名称
@property (nonatomic, strong) NSString * title;

/// 描述信息
@property (nonatomic, strong) NSString * desc;

/// 按钮文案信息
@property (nonatomic, strong) NSString * jumpDesc;

/// 微信号
@property (nonatomic, strong) NSString * wechat;

@end

NS_ASSUME_NONNULL_END
