//
//  QGSharePosterCollectionViewCell.m
//  VirtualPayment
//
//  Created by silicn on 2020/4/29.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGSharePosterCollectionViewCell.h"
#import "QGBasicUITool.h"
#import "UIImageView+WebCache.h"
#import "QGSharePosterModel.h"

@interface QGSharePosterCollectionViewCell ()

/// 背景图
@property (nonatomic, strong) UIImageView *bgImageView ;
/// 二维码
@property (nonatomic, strong) UIImageView *qrImageView ;
/// 邀请码
@property (nonatomic, strong) UILabel *codeLab ;

@end

@implementation QGSharePosterCollectionViewCell

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = UIColor.whiteColor;
        
        UIView *backView = [UIView creatViewWithSuperView:self backgroundColor:UIColor.whiteColor];
        [backView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.equalTo(self);
        }];
        
        self.bgImageView  = [UIImageView creatImageViewWithSuperView:backView imageName:nil];
        self.bgImageView.backgroundColor = UIColor.imageBackgroundColorF0F0F0;
        [self.bgImageView setRadius:6.0];
        [self.bgImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.bottom.equalTo(backView);
            make.centerX.equalTo(backView);
            make.width.equalTo(backView.mas_height).multipliedBy(9/16.0);
        }];

        self.qrImageView = [UIImageView creatImageViewWithSuperView:backView imageName:nil];
        [self.qrImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.equalTo(self.bgImageView);
            make.width.equalTo(self.bgImageView.mas_width).multipliedBy(103/312.0);
            make.height.equalTo(self.qrImageView.mas_width);
            make.bottom.inset(100.0/812.0 *MAINSCREEN_HEIGHT);
        }];

        UILabel *inviteLab = [UILabel creatLabelWithSuperView:backView title:@"邀请码" titleFontSize:[UIFont qg_regularFontOfSize:16.0f] textColor:UIColor.textColor3333 alignment:NSTextAlignmentCenter];
        [inviteLab mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.qrImageView.mas_bottom).offset(10);
            make.centerX.equalTo(self.qrImageView);
        }];

        UIView *Leftline = [UIView creatViewWithSuperView:backView backgroundColor:UIColor.textColor3333];

        [Leftline mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.equalTo(inviteLab);
            make.right.equalTo(inviteLab.mas_left).offset(-6);
            make.width.equalTo(self.qrImageView.mas_width).multipliedBy(0.35);
            make.height.mas_equalTo(0.5);
        }];

        UIView *rightLine = [UIView creatViewWithSuperView:backView backgroundColor:UIColor.textColor3333];

        [rightLine mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.equalTo(inviteLab);
            make.left.equalTo(inviteLab.mas_right).offset(6);
            make.width.equalTo(Leftline.mas_width);
            make.height.equalTo(Leftline.mas_height);
        }];

        UIView *codeBgView = [UIView creatViewWithSuperView:backView backgroundColor:[UIColor colorWithWhite:1 alpha:0.8]];
        [codeBgView setRadius:3.0f];

        [codeBgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo(128);
            make.height.mas_equalTo(22);
            make.centerX.equalTo(self.qrImageView);
            make.top.equalTo(inviteLab.mas_bottom).offset(10);
        }];

        self.codeLab = [UILabel creatLabelWithSuperView:codeBgView title:@"000000" titleFontSize:[UIFont qg_lightFontOfSize:16.0f] textColor:UIColor.textColor3333 alignment:NSTextAlignmentCenter];
        [self.codeLab mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.centerY.equalTo(codeBgView);
        }];
        
    }
    return self;
}


- (void)setPoster:(QGSharePosterModel *)poster
{
    _poster = poster;
    [self.bgImageView sd_setImageWithURL:[NSURL URLWithString:poster.img] placeholderImage:nil options:SDWebImageLowPriority];
    [self.qrImageView sd_setImageWithURL:[NSURL URLWithString:poster.qrImgUrl] placeholderImage:nil options:SDWebImageLowPriority];
    self.codeLab.text = poster.inviteCode;
}


@end
