//
//  QGBusinessFansViewController.m
//  VirtualPayment
//
//  Created by silicn on 2020/4/27.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBusinessFansViewController.h"
#import "QGBusinessFansViewCell.h"
#import "QGBusinessFansModel.h"
#import "QGBusinessRequestApi.h"

#import "QGFansEmptyView.h"

@interface QGBusinessFansViewController ()<UITableViewDelegate,UITableViewDataSource>

@property (nonatomic, strong)UITableView *tableView;

@property (nonatomic, strong)NSMutableArray *dataSource;

@property (nonatomic, copy) NSString *inviteRuleUrl;


@property (nonatomic, strong) QGFansEmptyView *emptyView;


@end

@implementation QGBusinessFansViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.dataSource  = [NSMutableArray array];
    
    
    self.emptyView = [[QGFansEmptyView alloc]init];
    [self.view addSubview:_emptyView];
    
    [self.emptyView mas_makeConstraints:^(MASConstraintMaker *make) {
        if (@available(iOS 11.0, *)) {
            make.top.equalTo(self.view.mas_safeAreaLayoutGuideTop);
        } else {
            make.top.equalTo(self.view.mas_top).inset(0);
        }
        make.left.right.inset(0);
    }];
    
    @weakify(self);
    self.emptyView.touchBlock = ^{
        [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGSharePosterViewController) parameters:nil handlerBlock:NULL];
    };
    
    self.tableView.pageNum = 1;
    self.tableView.pageCount = 20;
    
    [self.view addSubview:self.tableView];
    [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
        if (@available(iOS 11.0, *)) {
            make.top.equalTo(self.view.mas_safeAreaLayoutGuideTop);
        } else {
            make.top.equalTo(self.view.mas_top).inset(0);
        }
        make.left.right.bottom.equalTo(self.view);
    }];
    
    [self.tableView addRefreshWithHandle:^(BOOL isHeaderRefresh) {
        @strongify(self);
        [self requestDataIsReload:isHeaderRefresh];
    }];
    [self.tableView beginRefresh];
    
    // Do any additional setup after loading the view.
}

- (void)requestDataIsReload:(BOOL)reload
{
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    if (reload) {
        self.tableView.pageNum = 1;
    }
    [param setObject:@(self.type) forKey:@"followerType"];
    [param setObject:@(self.tableView.pageCount) forKey:@"pageSize"];
    [param setObject:@(self.tableView.pageNum) forKey:@"currentPageNo"];
    
    [networking GET:[QGBusinessRequestApi urlWithIndex:QGBusinessRequestServerMethodMyFans] parameters:param success:^(id  _Nonnull responseObject) {
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *data = responseObject[@"data"];
            NSArray *list = data[@"followerList"];
            self.inviteRuleUrl = data[@"inviteRuleUrl"];
            BOOL hasNext =  [data[@"hasNext"] boolValue];
            if (reload) {
                [self.dataSource removeAllObjects];
            }
            for (NSDictionary *dic in list) {
                QGBusinessFansModel *model = [QGBusinessFansModel yy_modelWithJSON:dic];
                [self.dataSource addObject:model];
            }
            [self.tableView reloadData];
            [self.tableView endRefreshWithBusinessSuccess:YES hasNext:hasNext];
            if (self.dataSource.count == 0) {
                [self showEmptyView];
            }else{
                self.emptyView.hidden = YES;
                self.tableView.hidden = NO;
            }
        }else{
            [self networkErrorPageWithPageNum:self.tableView.pageNum responseObject:responseObject error:nil];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [self networkErrorPageWithPageNum:self.tableView.pageNum responseObject:nil error:error];
    }];
}

- (void)showEmptyView
{
    self.emptyView.hidden = NO;
    self.tableView.hidden = YES;
    [self.view bringSubviewToFront:self.emptyView];
}

/// 网络错误页展示
/// @param pageNum 根据页码区分展示样式
/// @param responseObject 请求成功业务处理失败回调
/// @param error 请求失败错误信息
- (void)networkErrorPageWithPageNum:(NSInteger)pageNum responseObject:(NSDictionary *)responseObject error:(NSError *)error
{
    [self.tableView endRefreshWithBusinessSuccess:NO hasNext:YES];
    //如果是下拉刷新 && 之前没有数据，需要显示网络错误页面
    if (pageNum == 1 && self.dataSource.count == 0) {
        @weakify(self);
        QGDefaultView * view = [QGDefaultView defaultViewShowWithSuperView:self.view reloadBlock:^{
            @strongify(self);
            //开始下拉刷新
            [self.tableView beginRefresh];
        }];
        view.viewType = QGDefaultViewTypeBadNetwork;
    }
    //如果是请求成功业务处理失败，则弹出提示
    else if (responseObject)
    {
        [QGHUDManager showHudWithError:responseObject];
    }
    else if (error)
    {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return self.dataSource.count;
}

// Row display. Implementers should *always* try to reuse cells by setting each cell's reuseIdentifier and querying for available reusable cells with dequeueReusableCellWithIdentifier:
// Cell gets various attributes set automatically based on table (separators) and data source (accessory views, editing controls)

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    QGBusinessFansViewCell *cell =  (QGBusinessFansViewCell *)[self getCellFromClassName:NSStringFromClass([QGBusinessFansViewCell class]) dequeueTableView:tableView];
    cell.model = self.dataSource[indexPath.row];
    @weakify(self);
    cell.incomeBlock = ^(QGBusinessFansModel * _Nonnull model) {
        @strongify(self);
        [self toFansIncomeWith:model];
    };
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
}

- (void)toFansIncomeWith:(QGBusinessFansModel *)model
{
    [self navigationToWeb:model.followerIncomeUrl];
}

- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc]initWithFrame:CGRectZero style:UITableViewStylePlain];
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.estimatedRowHeight = 61;
        _tableView.rowHeight = 61;
        _tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    }
    return _tableView;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
