//
//  QGBusinessFansViewCell.m
//  VirtualPayment
//
//  Created by silicn on 2020/4/27.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBusinessFansViewCell.h"

#import "QGBasicUITool.h"

#import "QGBusinessFansModel.h"

#import "UIImageView+WebCache.h"


@interface QGBusinessFansViewCell ()

/// 头像
@property (nonatomic, strong)UIImageView *avatarImg;
/// 名字或者手机号
@property (nonatomic, strong) UILabel *nameLab ;

@property (nonatomic, strong) UILabel *levelLab ;

/// 时间
@property (nonatomic, strong) UILabel *timeLab ;
/// 粉丝收益按钮
@property (nonatomic, strong) UIButton *fanProfitBtn ;

@end

@implementation QGBusinessFansViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setups];
    }
    return self;
}

- (void)setups
{
    self.selectionStyle = UITableViewCellSelectionStyleNone;
    self.arrowHide = YES;
    self.avatarImg = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
//    _avatarImg.backgroundColor = UIColor.lineSeparatorColorDCDC;
    _avatarImg.layer.cornerRadius = 17;
    _avatarImg.clipsToBounds = YES;
    [self.avatarImg mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(20);
        make.size.mas_equalTo(CGSizeMake(34, 34));
        make.top.inset(16);
        make.bottom.inset(11);
    }];
    
    self.fanProfitBtn = [UIButton creatButtonWithBordercolor:UIColor.yyMainThemeColor cornerRadius:15.0 title:@"粉丝收益" titleFont:[UIFont qg_regularFontOfSize:13.0] textColor:UIColor.yyMainThemeColor];
    [self.contentView addSubview:_fanProfitBtn];
    
    [self.fanProfitBtn addTarget:self action:@selector(fansIncome) forControlEvents:UIControlEventTouchUpInside];
    
    [self.fanProfitBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.inset(20);
        make.centerY.equalTo(self.contentView);
        make.size.mas_equalTo(CGSizeMake(80, 30));
    }];
    
    [self.fanProfitBtn setContentCompressionResistancePriority:UILayoutPriorityDefaultHigh forAxis:UILayoutConstraintAxisHorizontal];
    
    self.nameLab = [UILabel creatLabelWithSuperView:self.contentView title:@"*********" titleFontSize:[UIFont qg_lightFontOfSize:15.0f] textColor:UIColor.textColor3333 alignment:NSTextAlignmentLeft];
    [self.nameLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.avatarImg.mas_right).offset(10);
        make.top.inset(12);
    }];
    
    [self.nameLab setContentCompressionResistancePriority:UILayoutPriorityDefaultLow forAxis:UILayoutConstraintAxisHorizontal];
    
    UIView *levelBackView = [[UIView alloc]init];
    levelBackView.backgroundColor = UIColor.whiteColor;
    [levelBackView setBorder:[UIColor colorWithHexString:@"E9B176"] width:1.0f];
    [levelBackView setRadius:3.0];
    [self.contentView addSubview:levelBackView];
    
    [levelBackView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.nameLab.mas_right).offset(4);
        make.height.mas_equalTo(15);
        make.centerY.equalTo(self.nameLab);
        make.right.lessThanOrEqualTo(self.fanProfitBtn.mas_left).offset(-10);
    }];
    
    [levelBackView setContentCompressionResistancePriority:UILayoutPriorityDefaultHigh forAxis:UILayoutConstraintAxisHorizontal];
    
    self.levelLab = [UILabel creatLabelWithSuperView:levelBackView title:@"*****" titleFontSize:[UIFont qg_lightFontOfSize:11.0] textColor:[UIColor colorWithHexString:@"E9B176"] alignment:NSTextAlignmentCenter];
    
 
    [self.levelLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.inset(3);
        make.top.bottom.inset(2);
    }];
    
    self.timeLab = [UILabel creatLabelWithSuperView:self.contentView title:@"0000-00:00:00" titleFontSize:[UIFont qg_lightFontOfSize:12.0f] textColor:UIColor.textColor9999 alignment:NSTextAlignmentLeft];
    [self.timeLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.nameLab);
        make.top.equalTo(self.nameLab.mas_bottom).offset(1);
        make.right.lessThanOrEqualTo(self.fanProfitBtn.mas_left).offset(-10);
    }];
    
    
}

/// 粉丝收益
- (void)fansIncome
{
    if (self.incomeBlock) {
        self.incomeBlock(self.model);
    }
}

- (void)setModel:(QGBusinessFansModel *)model
{
    _model = model;
    [self.avatarImg sd_setImageWithURL:[NSURL URLWithString:model.headImage] placeholderImage:[UIImage imageNamed:@"cashback_header_avatar"]];
    self.nameLab.text = model.name;
    self.timeLab.text = model.inviteTime;
    self.levelLab.text = model.levelName ? [NSString stringWithFormat:@"%@",model.levelName] : @"  ";
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
