//
//  QGDatePickerView.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/12.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGDatePickerView.h"
#import "QGBasicUITool.h"

@interface QGDatePickerView () <UIPickerViewDelegate, UIPickerViewDataSource>

//创建对象
@property (nonatomic, strong) UIPickerView * datePicker;

/// 年数据
@property (nonatomic, strong) NSArray * yearsArray;

/// 年份对应的月
@property (nonatomic, strong) NSDictionary * monthDic;

/// 第一个区的索引 默认是0
@property (nonatomic, assign) NSInteger firstIndex;

/// 第二个区的索引 默认是0
@property (nonatomic, assign) NSInteger secondIndex;

@end

@implementation QGDatePickerView


- (instancetype)initWithYearsArray:(NSArray *)yearsArray monthDic:(NSDictionary *)monthDic
{
    if (self = [super init]) {
        //数据源
        self.yearsArray = yearsArray;
        self.monthDic = monthDic;
        
        self.popType = PopViewTypeActionSheet;
        
        //标题
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"请选择时间" titleFontSize:[UIFont qg_regularFontOfSize:14] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.inset(20);
            make.centerX.offset(0);
            make.height.mas_equalTo(20);
        }];
        
        //完成按钮
        UIButton * doneButton = [UIButton creatButtonWithSuperView:self.contentView title:@"完成" titleFont:[UIFont qg_mediumFontOfSize:14] textColor:[UIColor textColor3333]];
        [doneButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(0);
            make.size.mas_equalTo(CGSizeMake(68, 40));
            make.top.inset(10);
        }];
        [doneButton addTarget:self action:@selector(doneButtonClick) forControlEvents:UIControlEventTouchUpInside];
        
        
        
        //选择器
        self.datePicker = [[UIPickerView alloc] init];
        [self.contentView addSubview:self.datePicker];
        [self.datePicker mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(titleLabel.mas_bottom).offset(10);
            make.left.right.bottom.inset(10);
        }];
        
        self.datePicker.delegate = self;
        self.datePicker.dataSource = self;
        
    }
    return self;
}



/// 外部反选内部位置
/// @param firstIndex 第一块的索引
/// @param secondIndex 第二块的索引
- (void)setFirstIndex:(NSInteger)firstIndex secondIndex:(NSInteger)secondIndex
{
    self.firstIndex = firstIndex;
    self.secondIndex = secondIndex;
    [self.datePicker selectRow:self.firstIndex inComponent:0 animated:NO];
    [self.datePicker selectRow:self.secondIndex inComponent:1 animated:NO];
}



#pragma mark - UIPickerViewDataSource
- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView
{
    return 2;
}

- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component
{
    NSInteger numberOfRows = 0;
    switch (component) {
            //第一块
        case 0:
            numberOfRows = self.yearsArray.count;
            break;
            //第二块
        case 1:
        {
            NSString * year = self.yearsArray[self.firstIndex];
            NSArray * monthsArray = self.monthDic[year];
            numberOfRows = monthsArray.count;
        }
        break;
            
        default:
            break;
    }
    return numberOfRows;
}

#pragma mark - UIPickerViewDelegate

- (void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row inComponent:(NSInteger)component
{
    if (component == 0)
    {
        self.firstIndex = row;
        self.secondIndex = 0;
        [pickerView reloadComponent:1];
        [pickerView selectRow:self.secondIndex inComponent:1 animated:NO];
    }
    else if (component == 1)
    {
        self.secondIndex = row;
    }
}


- (CGFloat)pickerView:(UIPickerView *)pickerView widthForComponent:(NSInteger)component
{
    return (MAINSCREEN_WIDTH - 20)/2.0;
}

- (CGFloat)pickerView:(UIPickerView *)pickerView rowHeightForComponent:(NSInteger)component
{
    return 45;
}

- (nullable NSString *)pickerView:(UIPickerView *)pickerView titleForRow:(NSInteger)row forComponent:(NSInteger)component
{
    NSString * titleForRow = @"";
    switch (component) {
            //年
        case 0:
            titleForRow = [NSString stringWithFormat:@"%@ 年",self.yearsArray[row]];
            break;
            //月
        case 1:
        {
            NSString * year = self.yearsArray[self.firstIndex];
            NSArray * monthsArray = self.monthDic[year];
            titleForRow = [NSString stringWithFormat:@"%@ 月",monthsArray[row]];
        }
            break;
            
        default:
            break;
    }
    return titleForRow;
}


- (UIView *)pickerView:(UIPickerView *)pickerView viewForRow:(NSInteger)row forComponent:(NSInteger)component reusingView:(UIView *)view{
    UILabel* pickerLabel = (UILabel*)view;
    if (!pickerLabel){
        pickerLabel = [[UILabel alloc] init];
        pickerLabel.minimumScaleFactor = 8.;
        pickerLabel.adjustsFontSizeToFitWidth = YES;
        [pickerLabel setTextAlignment:NSTextAlignmentCenter];
        [pickerLabel setBackgroundColor:[UIColor clearColor]];
        [pickerLabel setFont:[UIFont qg_regularFontOfSize:18]];
        pickerLabel.textColor = [UIColor textColor3333];
    }
    pickerLabel.text= [self pickerView:pickerView titleForRow:row forComponent:component];
    return pickerLabel;
}


#pragma mark - Action

/// 完成按钮点击
- (void)doneButtonClick
{
    if (self.doneBlock) {
        self.doneBlock(self.firstIndex, self.secondIndex);
    }
    [self dismissView:nil];
}

@end
