//
//  QGCardRequestApi.h
//  VirtualPayment
//
//  Created by 张博 on 2019/7/3.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSUInteger, QGCardRequestServerMethod) {
    ///享花卡状态接口
    QGCardRequestServerMethodBlanknoteStatus,
    ///激活按钮应该请求的接口
    QGCardRequestServerMethodActiveUrl,
    ///提额页面接口
    QGCardRequestServerMethodCreditInfo,
    ///三组分期选择
    QGCardRequestServerMethodSelectTermsDetail,
    ///可配置分期组用户更新分期
    QGCardRequestServerMethodUserTermsUpdate,
    ///绑定钱包接口
    QGCardRequestServerMethodBindWalletStep,
    ///缓存用户IP和mac地址
    QGCardRequestServerMethodCacheIpMacAddress,
    ///开启返现
    QGCardRequestServerMethodReturnCashSigned,
    /// 活动窗口
    QGCardRequestServerMethodActivity,
    ///版本更新
    QGCardRequestServerMethodAPPUpdata,
    ///获取激活额度跳转URL
    QGCardRequestServerMethodActiveCreditUrl,
    ///立即申请额度时请求的接口
    QGCardRequestServerMethodActiveCreditApply,
    ///交易设置查询
    QGCardRequestServerMethodTransactionSettings,
    ///交易设置保存
    QGCardRequestServerMethodSaveSetting,
    ///查询储蓄账户信息
    QGCardRequestServerMethodSavingsAccountQuery,

};



NS_ASSUME_NONNULL_BEGIN

@interface QGCardRequestApi : NSObject

/*
 接口URL
 */
+ (NSString *)urlWithIndex:(QGCardRequestServerMethod)index;

@end

NS_ASSUME_NONNULL_END
