//
//  QGTransactionTipsCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/3.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGTransactionTipsCell.h"
#import "QGBasicUITool.h"

@interface QGTransactionTipsCell ()

/// 提示
@property (nonatomic, strong, readwrite) UILabel * tipLabel;

@end

@implementation QGTransactionTipsCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        self.contentView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
        //提示
        self.tipLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        self.tipLabel.numberOfLines = 0;
        [self.tipLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.centerY.offset(0);
        }];
        
    }
    return self;
}


@end
