//
//  QGSelectTermViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2019/9/23.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGSelectTermViewController.h"
//Model
#import "QGConfigInstallmentPlanModel.h"
//View
#import "QGSelectTermHeaderCell.h"
#import "QGSelectTermDescCell.h"
#import "QGGradientShadowButton.h"

#import "QGCardRequestApi.h"
@interface QGSelectTermViewController ()

/// 分期计划
@property (nonatomic, strong) QGConfigInstallmentPlanModel * configPlanModel;

/// 当前选中的分期
@property (nonatomic, strong) QGCanSelectTermModel * currentSelectTerm;

@end

@implementation QGSelectTermViewController

/**
 检查入参是否正确 需要子类重写
 
 @param param 入参
 @return 返回参数检查是否通过
 */
- (BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}



- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self custemLeftDefaultBarButtonItem];
    self.title = @"选择交易分期数";
    [self creatNormalUI];
    [self requestInstallmentPlan];
}

- (void)creatNormalUI
{
    //预留安全区域和按钮
    self.distanceBottom = 70 + ([DeviceAdaptation isIphoneXSeries] ? [DeviceAdaptation getBottomSafeAreaHeight] : 0);
    
    UIView * bottomView = [UIView creatViewWithSuperView:self.view backgroundColor:[UIColor whiteColor]];
    [bottomView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.offset(0);
        make.bottom.inset([DeviceAdaptation isIphoneXSeries] ? [DeviceAdaptation getBottomSafeAreaHeight] : 0);
        make.height.mas_equalTo(70);
    }];
    
    //顶部线条
    UIView * lineView = [UIView creatViewWithSuperView:bottomView backgroundColor:[UIColor lineSeparatorColorDCDC]];
    [lineView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.top.inset(0);
        make.height.mas_equalTo(0.5);
    }];
    
    //按钮
    QGGradientShadowButton * sureButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:bottomView title:@"确定" textFont:[UIFont qg_regularFontOfSize:17]];
    [sureButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.inset(20);
        make.height.mas_equalTo(40);
        make.centerY.inset(0);
    }];
    
    [sureButton addTarget:self action:@selector(sureButtonClick) forControlEvents:UIControlEventTouchUpInside];
}


///请求分期方案  1: 可配置分期组
- (void)requestInstallmentPlan
{
    [QGHUDManager showHud:nil];
    @weakify(self);
//    NSString * urlString = @"http://yapi.quantgroups.com/mock/169/vcc/mvp/user/selectTerms/detail";
    NSString * urlString = [QGCardRequestApi urlWithIndex:QGCardRequestServerMethodSelectTermsDetail];
    [[QGTalosNetwork shareManager] GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
        @strongify(self);
        [QGHUDManager hideHud];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            self.configPlanModel = [QGConfigInstallmentPlanModel yy_modelWithDictionary:responseObject[@"data"]];
            [self resetNormalData];
            [self.tableView reloadData];
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        NSString * errorMessage = [QGBaseNetwork getMessageWithFailureError:error];
        [QGHUDManager showHud:errorMessage];
    }];
}



- (void)resetNormalData
{
    //找出默认选中的分期方案
    for (QGCanSelectTermModel * selectTerm in self.configPlanModel.canConfigTermsDetail.canSelectTerms) {
        if (selectTerm.selectedTerm) {
            self.currentSelectTerm = selectTerm;
            break;
        }
    }
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 2;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    UITableViewCell * cell;
    switch (indexPath.row) {
        case 0:
        {
            QGSelectTermHeaderCell * headerCell = (QGSelectTermHeaderCell *)[self getCellFromClassName:NSStringFromClass([QGSelectTermHeaderCell class]) dequeueTableView:tableView];
            headerCell.canConfigTermsDetail = self.configPlanModel.canConfigTermsDetail;
            headerCell.currentSelectTerm = self.currentSelectTerm;
            
            //选择分期回调
            @weakify(self);
            headerCell.selectCallback = ^(QGCanSelectTermModel * _Nonnull selectTermModel) {
                @strongify(self);
                self.currentSelectTerm = selectTermModel;
            };
            cell = headerCell;
        }
            break;
        case 1:
        {
            QGSelectTermDescCell * descCell = (QGSelectTermDescCell *)[self getCellFromClassName:NSStringFromClass([QGSelectTermDescCell class]) dequeueTableView:tableView];
            descCell.canConfigTermsDetail = self.configPlanModel.canConfigTermsDetail;
            cell = descCell;
        }
            break;
            
            
        default:
            break;
    }
    return cell ? cell : [UITableViewCell new];
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CGFloat heightForRow = 0;
    switch (indexPath.row) {
        case 0:
            heightForRow = self.configPlanModel.canConfigTermsDetail.headerCellHeight;
            break;
        case 1:
            heightForRow = self.configPlanModel.canConfigTermsDetail.descCellHeight;
            break;
            
            
        default:
            break;
    }
    return heightForRow;
}
/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

#pragma mark - Action
///确认按钮事件
- (void)sureButtonClick
{
    if (!self.currentSelectTerm) {
        [QGHUDManager showHud:@"请选择交易分期"];
        return;
    }
//    NSString * urlString = @"http://yapi.quantgroups.com/mock/169/vcc/mvp/userTerms/update";
    NSString * urlString = [QGCardRequestApi urlWithIndex:QGCardRequestServerMethodUserTermsUpdate];
    NSDictionary * infoDic = @{@"updateTerm":self.currentSelectTerm.term};
    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] POST:urlString parameters:infoDic success:^(id  _Nonnull responseObject) {
        if ( [QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            [QGHUDManager showHud:@"设置分期后，每一笔消费会被自动分期"];
            [self.navigationController popViewControllerAnimated:YES];
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
        
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        NSString * errorMessage = [QGBaseNetwork getMessageWithFailureError:error];
        [QGHUDManager showHud:errorMessage];
    }];
}

@end
