//
//  QGShouldAmountHeaderCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/9/29.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGShouldAmountHeaderCell.h"
#import "QGBasicUITool.h"

@interface QGShouldAmountHeaderCell ()

/// 应还金额
@property (nonatomic, strong, readwrite) UILabel * shouldAmountLabel;

@end

@implementation QGShouldAmountHeaderCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        //剩余待还
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"剩余待还(元)" titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
        [titleLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.centerX.offset(0);
            make.top.offset(30);
            make.height.mas_equalTo(17);
        }];
        
        //待还金额
        self.shouldAmountLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:30] textColor:[UIColor textColor3333] alignment:NSTextAlignmentCenter];
        [self.shouldAmountLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.mas_equalTo(titleLabel.mas_bottom).offset(12);
            make.height.mas_equalTo(30);
        }];
        
        //包含以下部分
        UIView * bottomView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor moduleSeparatorColorF7F7]];
        [bottomView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.left.right.bottom.offset(0);
            make.height.mas_equalTo(40);
        }];
        
        UILabel * subTitleLabel = [UILabel creatLabelWithSuperView:bottomView title:@"包含以下部分" titleFontSize:[UIFont qg_lightFontOfSize:14] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [subTitleLabel mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.bottom.offset(0);
        }];
        
    }
    return self;
}



- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
