//
//  QGShouldAmountCenterCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/9/29.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGShouldAmountCenterCell.h"

#import "QGBasicUITool.h"
@interface QGShouldAmountCenterCell ()

/// 标题
@property (nonatomic, strong, readwrite) UILabel * titleLabel;

/// 金额
@property (nonatomic, strong, readwrite) UILabel * amountLabel;
@end

@implementation QGShouldAmountCenterCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:16] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.offset(20);
            make.top.bottom.offset(0);
        }];
        
        //金额
        self.amountLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:16] textColor:[UIColor textColor3333] alignment:NSTextAlignmentRight];
        [self.amountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(38);
            make.top.bottom.offset(0);
        }];
        
    }
    return self;
}

- (void)setArrowHide:(BOOL)arrowHide
{
    [super setArrowHide:arrowHide];
    if (arrowHide) {
        [self.amountLabel mas_updateConstraints:^(MASConstraintMaker *make) {
            make.right.inset(20);
        }];
    }
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
