//
//  QGrepaymentSectionView.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/26.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGrepaymentSectionView.h"
#import "QGBasicUITool.h"


@interface QGrepaymentSectionView()

@property (nonatomic, strong) UILabel *titleLab ;

@property (nonatomic, strong) UIImageView *imageView;

@property (nonatomic, strong) UIView *separateLine;



@end

@implementation QGrepaymentSectionView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = [UIColor whiteColor];
        self.titleLab = [UILabel creatLabelWithSuperView:self title:nil titleFontSize:[UIFont qg_mediumFontOfSize:16.0f] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self).inset(20);
            make.centerY.equalTo(self);
        }];
        
        self.imageView = [UIImageView creatImageViewWithSuperView:self imageName:@"section_down"];
        [self.imageView  mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.titleLab.mas_right).offset(8);
            make.centerY.equalTo(self.titleLab);
        }];
        
        self.separateLine = [UIView creatViewWithSuperView:self backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [self.separateLine mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self).inset(20);
            make.bottom.equalTo(self);
            make.height.mas_equalTo(0.5);
        }];
        
        UIButton *btn = [UIButton creatButtonWithSuperView:self title:nil titleFont:[UIFont qg_lightFontOfSize:15.0f] textColor:[UIColor whiteColor]];
        [btn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.equalTo(self);
        }];
        [btn addTarget:self action:@selector(btnAction:) forControlEvents:UIControlEventTouchUpInside];
        
    }
    return self;
}

- (void)btnAction:(UIButton *)btn
{
    if (self.touchBlock) {
        self.touchBlock();
    }
}

- (void)setOpen:(BOOL)open
{
    if (_open != open) {
        _open = open;
        self.imageView.image = [UIImage imageNamed:open ? @"section_up":@"section_down"];
    }
}

- (void)setTitle:(NSString *)title
{
    if (_title != title) {
        _title = title;
        self.titleLab.text = title;
    }
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
