//
//  QGRepaymentPieView.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/24.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGRepaymentPieView.h"
#import "QGBasicUITool.h"


@interface QGRepaymentPieView()
/// 饼
@property (nonatomic, strong)CAShapeLayer *shaperLayer;
/// 圆
@property (nonatomic, strong)CAShapeLayer *circleLayer;


@end

@implementation QGRepaymentPieView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = [UIColor clearColor];
    }
    return self;
}


- (void)layoutSubviews
{
    [super layoutSubviews];
    [self drawCircle];
    [self drawPieWithPercent:self.percent];
}

- (void)setPercent:(CGFloat)percent
{
    if (_percent != percent) {
        _percent = percent;
        [self setNeedsLayout];
    }
}

///画一个圆
- (void)drawCircle
{
    UIBezierPath *circlePath = [UIBezierPath bezierPath];
    CGPoint center = CGPointMake(self.frame.size.width/2, self.frame.size.height/2);
    CGFloat radius = self.frame.size.width > self.frame.size.height ? self.frame.size.height/2:self.frame.size.width/2;
    [circlePath addArcWithCenter:center radius:radius startAngle:0 endAngle: 2 * M_PI  clockwise:YES];
    self.circleLayer.path = circlePath.CGPath;
}

///画饼状图
- (void)drawPieWithPercent:(CGFloat)percent
{
    if (self.percent<= 0) return ;
    
    CGPoint center = CGPointMake(self.frame.size.width/2, self.frame.size.height/2);
    CGFloat radius = self.frame.size.width > self.frame.size.height ? self.frame.size.height/2:self.frame.size.width/2;
    UIBezierPath *path = [UIBezierPath bezierPath];
    [path moveToPoint:center];
    [path addArcWithCenter:center radius:radius  startAngle:-M_PI_2 endAngle: percent * 2 * M_PI - M_PI_2 clockwise:YES];
    [path closePath];
    
    self.shaperLayer.path = path.CGPath;
   
}

- (CAShapeLayer *)circleLayer
{
    if (!_circleLayer) {
        _circleLayer = [CAShapeLayer layer];
        _circleLayer.strokeColor = [UIColor colorWithHexString:@"FF5A4B"].CGColor;
        _circleLayer.frame = self.bounds;
        _circleLayer.lineWidth = 1;
        _circleLayer.fillColor = [UIColor whiteColor].CGColor;
        [self.layer addSublayer:_circleLayer];
    }
    return _circleLayer;
}

- (CAShapeLayer *)shaperLayer
{
    if (!_shaperLayer) {
        _shaperLayer = [CAShapeLayer layer];
        _shaperLayer.strokeColor = [UIColor colorWithHexString:@"FF5A4B"].CGColor;
        _shaperLayer.frame = self.bounds;
        _shaperLayer.fillColor = [UIColor colorWithHexString:@"FF5A4B"].CGColor;
        _shaperLayer.lineWidth = 1;
        [self.layer addSublayer:_shaperLayer];
    }
    return _shaperLayer;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
