//
//  QGRepaymentOverDueCell.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/26.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGRepaymentOverDueCell.h"

#import "QGBasicUITool.h"

#import "QGRepaymentOverdueModel.h"



@interface QGRepaymentOverDueCell()
///白色背景有阴影
@property (nonatomic, strong) UIView *backView;
///*月应还-逾期未还
@property (nonatomic, strong) UILabel *titleLab ;
///截止日期 :9月10日
@property (nonatomic, strong) UILabel *deadlineLab ;
///金额
@property (nonatomic, strong) UILabel *amountLab ;
///警示文字 :逾期后每天会收取您逾期滞纳金!请尽快还款!
@property (nonatomic, strong) UILabel *warningLab ;


@end


@implementation QGRepaymentOverDueCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self  = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        [self setups];
    }
    return self;
}

- (void)setups
{
    self.separateLineHide = YES;
    self.titleLab  = [UILabel creatLabelWithSuperView:self.contentView title:@"*月应还-逾期未还" titleFontSize:[UIFont qg_mediumFontOfSize:16.0f] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    [self.titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.contentView).inset(20);
        make.top.equalTo(self.contentView).inset(20);
    }];
    
    
    self.backView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor whiteColor]];
    [self.backView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.titleLab.mas_bottom).offset(10);
        make.left.right.equalTo(self.contentView).inset(20);
        make.bottom.equalTo(self.contentView).inset(8);
    }];
    
    [self.backView setShadowColor:[UIColor colorWithHexString:@"372D2D" alpha:0.2] shadowRadius:4 shadowOffset:CGSizeMake(1, 1) cornerRadius:0];
    
    self.deadlineLab = [UILabel creatLabelWithSuperView:self.backView title:@"截止今日" titleFontSize:[UIFont qg_lightFontOfSize:12.0f] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    self.amountLab =[UILabel creatLabelWithSuperView:self.backView title:@"金额" titleFontSize:[UIFont qg_numberFontOfSize:30.0f] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    self.warningLab = [UILabel creatLabelWithSuperView:self.backView title:@"逾期后每天会收取您逾期滞纳金!请尽快还款!" titleFontSize:[UIFont qg_lightFontOfSize:12.0f] textColor:[UIColor textColorF41C1C] alignment:NSTextAlignmentLeft];
    
    [self.deadlineLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.equalTo(self.backView).inset(20);
    }];
    
    [self.amountLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.deadlineLab);
        make.top.equalTo(self.deadlineLab.mas_bottom).offset(7);
    }];
    [self.warningLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.amountLab);
        make.top.equalTo(self.amountLab.mas_bottom).offset(13);
        make.bottom.equalTo(self.backView).inset(20);
    }];
    
    self.arrowHide = YES;
}

+ (instancetype)initWithTableView:(UITableView *)tableView
{
    static NSString *identifier = @"QGRepaymentOverDueCell";
    
    QGRepaymentOverDueCell *cell = [tableView dequeueReusableCellWithIdentifier:identifier];
    if (cell == nil) {
        [tableView registerClass:[QGRepaymentOverDueCell class] forCellReuseIdentifier:identifier];
        cell = [[QGRepaymentOverDueCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:identifier];
    }
    return cell;
}

- (void)setModel:(QGRepaymentOverdueModel *)model
{
    if (_model != model) {
        _model = model;
        _titleLab.text = [NSString stringWithFormat:@"%@-逾期未还",model.billName];
        _amountLab.text = [NSString stringWithFormat:@"%@",model.amount];
    }
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
