//
//  QGRepaymentOrderListCell.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/21.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGRepaymentOrderListCell.h"
#import "QGBasicUITool.h"
#import "QGCalendarManager.h"
#import "QGRepaymentAmortizeOrderModel.h"



@interface QGRepaymentOrderListCell()
///月份
@property (nonatomic, strong)UILabel *dateLab;
///是否退货
@property (nonatomic, strong)UILabel *statusLab;
///账单明细
@property (nonatomic, strong)UILabel *contentLab;
///账单金额
@property (nonatomic, strong) UILabel *amountLab;
/// 优惠金额
@property (nonatomic, strong) UILabel *cheapLab ;


@end

@implementation QGRepaymentOrderListCell



- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setups];
    }
    return self;
}

- (void)setups
{
    // 日期
    self.dateLab = [UILabel creatLabelWithSuperView:self.contentView title:@" " titleFontSize:[UIFont qg_lightFontOfSize:14.0f] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
    // 是否退货
    self.statusLab = [UILabel creatLabelWithSuperView:self.contentView title:@" " titleFontSize:[UIFont qg_mediumFontOfSize:12.0f] textColor:[UIColor textColor3333] alignment:NSTextAlignmentRight];
    // 消费商品
    self.contentLab = [UILabel creatLabelWithSuperView:self.contentView title:@"  " titleFontSize:[UIFont qg_lightFontOfSize:14.0f] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    // 消费金额
    self.amountLab = [UILabel creatLabelWithSuperView:self.contentView title:@" " titleFontSize:[UIFont qg_regularFontOfSize:14.0f] textColor:[UIColor textColor3333] alignment:NSTextAlignmentRight];
    // 优惠金额
    self.cheapLab = [UILabel creatLabelWithSuperView:self.contentView title:@" " titleFontSize:[UIFont qg_lightFontOfSize:10.f] textColor:UIColor.yyMainThemeColor alignment:NSTextAlignmentRight];
    
    
    [self.dateLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.contentView).inset(20);
        make.top.equalTo(self.contentView).inset(15);
    }];
    
    [self.statusLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(self.contentView).inset(20);
        make.centerY.equalTo(self.dateLab.mas_centerY);
    }];
    
    [self.contentLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.dateLab);
        make.top.equalTo(self.dateLab.mas_bottom).offset(6);
        make.right.equalTo(self.amountLab.mas_left).offset(-8);
    }];
    
    [self.amountLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(self.statusLab);
        make.centerY.equalTo(self.contentLab.mas_centerY);
    }];
    
    
    [self.cheapLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.contentLab.mas_bottom).offset(4);
        make.right.equalTo(self.amountLab);
        make.bottom.equalTo(self.contentView).inset(10);
    }];
    
    self.arrowHide = YES;
    
    
    
}

- (void)setModel:(QGRepaymentAmortizeOrderModel *)model
{
    if (_model != model) {
        _model = model;
        NSDate *date = [NSDate dateWithTimeIntervalSince1970:model.orderTime/1000];
        NSString *time = [[QGCalendarManager shareInstance] getStringFromDate:date formatter:@"M月d日 HH:mm"];
        _dateLab.text = time;
        _contentLab.text = model.orderName;
        _statusLab.text = model.refundFlag ? model.refundFlag :@"";
        _cheapLab.text = model.couponInfo;
        
        
        //是否提前还款
        if (model.preRepayType) {
            //提前还款加粗显示
            self.contentLab.font = [UIFont qg_mediumFontOfSize:14];
            self.amountLab.font = [UIFont qg_mediumFontOfSize:14];
            _amountLab.text = [NSString stringWithFormat:@"-%@元",model.orderAmount];
        }
        else
        {
            self.contentLab.font = [UIFont qg_lightFontOfSize:14];
            self.amountLab.font = [UIFont qg_regularFontOfSize:14];
            _amountLab.text = [NSString stringWithFormat:@"%@元",model.orderAmount];
        }
        
    }
}

+ (instancetype)initWithTableView:(UITableView *)tableView
{
    static NSString *idientifier = @"QGRepaymentOrderListCell";
    QGRepaymentOrderListCell *cell = [tableView dequeueReusableCellWithIdentifier:idientifier];
    if (cell == nil) {
        [tableView registerClass:[QGRepaymentOrderListCell class] forCellReuseIdentifier:idientifier];
        cell = [[QGRepaymentOrderListCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:idientifier];
    }
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    return cell;
}

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
