//
//  QGRepaymentListViewCell.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/21.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGRepaymentListViewCell.h"
#import "QGBasicUITool.h"

@implementation QGRepaymentStatusBillItem


@end


@interface QGRepaymentListViewCell()
///账单金额
@property (nonatomic, strong)UILabel *titleLab;
///0000.00元
@property (nonatomic, strong)UILabel *contentLab;


@end

@implementation QGRepaymentListViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        self.titleLab = [UILabel creatLabelWithSuperView:self.contentView title:@"账单金额" titleFontSize:[UIFont qg_lightFontOfSize:16.0f] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        self.contentLab = [UILabel creatLabelWithSuperView:self.contentView title:@"0000.00元" titleFontSize:[UIFont qg_lightFontOfSize:16.0f] textColor:[UIColor textColor3333] alignment:NSTextAlignmentRight];
        [self.titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.contentView).inset(20);
            make.top.bottom.equalTo(self.contentView).inset(18);
        }];
        
        [self.contentLab mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerY.equalTo(self.titleLab.mas_centerY);
            make.right.equalTo(self.arrowImage.mas_left).offset(-8);
            make.left.greaterThanOrEqualTo(self.titleLab.mas_rightMargin);
        }];
    }
    return self;
}

- (void)setItem:(QGRepaymentStatusBillItem *)item
{
    if (_item != item) {
        _item = item;
        self.titleLab.text = item.title;
        self.contentLab.text = item.content;
    }
}


+ (instancetype)initWithTableView:(UITableView *)tableView
{
    static NSString *identifier = @"QGRepaymentListViewCell";
    QGRepaymentListViewCell *cell = [tableView dequeueReusableCellWithIdentifier:identifier];
    if (cell == nil) {
        [tableView registerClass:[QGRepaymentListViewCell class] forCellReuseIdentifier:identifier];
        cell = [[QGRepaymentListViewCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:identifier];
    }
    return cell;
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
