//
//  QGRepaymentHeadView.h
//  VirtualPayment
//
//  Created by silicn on 2019/6/20.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGHitTestView.h"
#import "QGRepaymentBillModel.h"

#import "QGRepaymentListViewCell.h"




NS_ASSUME_NONNULL_BEGIN
// 点击本月账单，已还，或者分期Item
typedef void(^QGStatusListViewTouchBlock)(QGRepaymentStatusBillItem *item);

//用来控制本对象是否可以被点击
typedef void(^QGRepaymentListViewCanClickBlock)(BOOL canClick);

@interface QGRepaymentListView : UIView
///设置是否可以点击
@property (nonatomic, copy)QGRepaymentListViewCanClickBlock canClickBlock;
///账单model
@property (nonatomic, strong)QGRepaymentBillModel *model;

/// 当且仅当状态是:已还清 点击顶部账单、已还、分期等item的回调
@property (nonatomic, copy)QGStatusListViewTouchBlock touchItemBlock;

/// 待还金额详情
@property (nonatomic, copy) dispatch_block_t showAmountDetailBolck;

/**
 撤销下拉动作，隐藏BlurEffectView
 */
- (void)dismissBlurEffectView;


@end

NS_ASSUME_NONNULL_END
