//
//  QGRepaymentHistoryListCell.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/27.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGRepaymentHistoryListCell.h"
#import "QGBasicUITool.h"

#import "QGRepaymentHistoryModel.h"

@interface QGRepaymentHistoryListCell()
///*月账单
@property (nonatomic, strong) UILabel *monthLab ;
///账单状态
@property (nonatomic, strong) UILabel *statusLab ;
///金额
@property (nonatomic, strong) UILabel *amountLab ;




@end
@implementation QGRepaymentHistoryListCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

-(id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        [self setups];
    }
    return self;
}

- (void)setups
{
    self.monthLab = [UILabel creatLabelWithSuperView:self.contentView title:@"*月账单" titleFontSize:[UIFont qg_lightFontOfSize:(14.0f)] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    self.statusLab = [UILabel creatLabelWithSuperView:self.contentView title:@"账单状态" titleFontSize:[UIFont qg_lightFontOfSize:14.0f] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    self.amountLab = [UILabel creatLabelWithSuperView:self.contentView title:@"金额" titleFontSize:[UIFont qg_regularFontOfSize:14.0f] textColor:[UIColor textColor3333] alignment:NSTextAlignmentRight];
    
    [self.monthLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.contentView).inset(20);
        make.top.equalTo(self.contentView).inset(15);
    }];
    
    [self.statusLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.monthLab);
        make.top.equalTo(self.monthLab.mas_bottom).offset(8);
        make.bottom.equalTo(self.contentView.mas_bottom).inset(15);
    }];
    
    [self.amountLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(self.arrowImage.mas_left).inset(8);
        make.centerY.equalTo(self.contentView);
    }];
}

+ (instancetype)initWithTableView:(UITableView *)tableView
{
    static NSString *identifier = @"QGRepaymentHistoryListCell";
    
    QGRepaymentHistoryListCell *cell = [tableView dequeueReusableCellWithIdentifier:identifier];
    if (cell == nil) {
        [tableView registerClass:[QGRepaymentHistoryListCell class] forCellReuseIdentifier:identifier];
        cell = [[QGRepaymentHistoryListCell alloc]initWithStyle:UITableViewCellStyleDefault reuseIdentifier:identifier];
    }
    return cell;
}


-(void)setModel:(QGRepaymentHistoryModel *)model
{
    if (_model != model) {
        _model = model;
        _monthLab.text = [NSString stringWithFormat:@"%@月账单",model.billMonth];
        _statusLab.text = [self stringForStatus:model.status];
        if (model.status == 3) {
            _statusLab.textColor = [UIColor textColorF41C1C];
        }else{
            _statusLab.textColor = [UIColor textColor3333];
        }
        _amountLab.text = [NSString stringWithFormat:@"%@",model.billAmount];
    }
}

- (NSString *)stringForStatus:(NSInteger)status
{
    if (status == 0) {
        return @"已还清";
    }else if (status == 1) {
        return @"待还";
    }else if (status == 2) {
        return @"还款中";
    }else if (status == 3) {
        return @"已逾期";
    }
    return nil;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
