//
//  QGRepaymentBottomView.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/24.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGRepaymentBottomView.h"

#import "QGGradientShadowButton.h"

#import "UIView+Extend.h"

#import "QGBasicUITool.h"

#import "UIButton+QGAdd.h"


@interface QGRepaymentBottomView ()

@property (nonatomic, strong)UIView *topLine;

@property (nonatomic, strong)UIButton *leftBtn;

@property (nonatomic, strong)QGGradientShadowButton *rightBtn;

@property (nonatomic, strong) UIView *backgroudView;


@end

@implementation QGRepaymentBottomView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.backgroundColor = [UIColor whiteColor];
        [self setups];
    }
    return self;
}

- (id)init
{
    self = [super init];
    if (self) {
        self.canUserExpress = YES;
    }
    return self;
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    self.backgroudView.layer.cornerRadius = self.backgroudView.frame.size.height/2;
}

- (void)setups
{
    
    self.topLine = [UIView creatViewWithSuperView:self backgroundColor:[UIColor colorWithHexString:@"EDEDED"]];
    
    [self.topLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.equalTo(self);
        make.height.mas_equalTo(0.5);
    }];
    
    self.backgroudView = [UIView creatViewWithSuperView:self backgroundColor:[UIColor whiteColor]];
    
    [self.backgroudView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.bottom.equalTo(self).inset(15);
        make.left.right.equalTo(self).inset(20);
    }];
    
    [self.backgroudView setBorder:[UIColor colorWithHexString:@"FF5A4B"] width:1.0f];
    self.backgroudView.layer.masksToBounds = YES;
    
    self.leftBtn = [UIButton creatButtonWithSuperView:self.backgroudView title:@"提前还款" titleFont:[UIFont qg_regularFontOfSize:17.0f] textColor:[UIColor colorWithHexString:@"FF5A4B"]];
    self.rightBtn = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.backgroudView title:@"分期还款" textFont:[UIFont qg_regularFontOfSize:17.0f]];
    self.rightBtn.isClearCorner = YES;
    
    [self.rightBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.bottom.right.equalTo(self.backgroudView).inset(-1);
        make.width.equalTo(self.backgroudView.mas_width);
    }];
    [self.leftBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.bottom.equalTo(self.backgroudView);
        make.width.equalTo(self.backgroudView.mas_width).multipliedBy(0.5);
    }];
    
    @weakify(self);
    [self.leftBtn touchEventBlock:^(UIButton * _Nonnull button) {
        @strongify(self);
        if (self.actionBlock) {
            self.actionBlock(NO);
        }
    } forControlEvents:UIControlEventTouchUpInside];
    
    [self.rightBtn touchEventBlock:^(UIButton * _Nonnull button) {
        @strongify(self);
        if (self.actionBlock) {
            self.actionBlock(YES);
        }
    } forControlEvents:UIControlEventTouchUpInside];

}

- (void)setLeftTitle:(NSString *)leftTitle rightTitle:(NSString *)rightTitle
{
    [self.leftBtn setTitle:leftTitle forState:UIControlStateNormal];
    [self.rightBtn setTitle:rightTitle forState:UIControlStateNormal];
}

- (void)setType:(RepaymentBottomType)type
{
    _type = type;
    if (type == RepaymentBottomTypeNomal) {
        [self.rightBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.top.bottom.right.equalTo(self.backgroudView).inset(-1);
            make.width.equalTo(self.leftBtn.mas_width);
        }];
    }else{
        [self.rightBtn mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.top.bottom.right.left.equalTo(self.backgroudView).inset(-1);
        }];
    }
}

- (void)setCanUserExpress:(BOOL)canUserExpress
{
    if (_canUserExpress != canUserExpress) {
        _canUserExpress = canUserExpress;
        
        if (canUserExpress) {
            [self.backgroudView setBorder:[UIColor colorWithHexString:@"FF5A4B"] width:1.0f];
            [self.rightBtn setGradientButtonIsClickEnabled:YES];
            [self.leftBtn setTitleColor:[UIColor colorWithHexString:@"FF5A4B"] forState:UIControlStateNormal];
            self.leftBtn.userInteractionEnabled = YES;
        }else{
             [self.backgroudView setBorder:[UIColor colorWithHexString:@"BFBFBF"] width:1.0f];
            self.backgroudView.layer.masksToBounds = YES;
            [self.rightBtn setGradientButtonIsClickEnabled:NO];
            [self.leftBtn setTitleColor:[UIColor colorWithHexString:@"BFBFBF"] forState:UIControlStateNormal];
            self.leftBtn.userInteractionEnabled = NO;
        }
    }
}


/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
