//
//  QGPaymentStatusView.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/20.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGPaymentStatusView.h"
#import "QGCalendarManager.h"

#import "QGBasicUITool.h"


@interface QGPaymentStatusView()

///标题：剩余待还
@property (nonatomic, strong)UILabel *titleLab;
///文本：金额或者已还清
@property (nonatomic, strong)UILabel *textLab;
///副标题：这个月不用还了
@property (nonatomic, strong)UILabel *subTextLab;
/// 逾期
@property (nonatomic, strong)UILabel *warningLab;
/// 下拉button
@property (nonatomic, strong)UIButton *upBtn;
/// 右图标
@property (nonatomic, strong)UIImageView *imageView;

@property (nonatomic, assign)BOOL down;

/// 查看详情 只有在应还和逾期的时候显示
@property (nonatomic, strong) UIButton * showDetail;




@end


@implementation QGPaymentStatusView

- (id)initWithFrame:(CGRect)frame
{
    self  = [super initWithFrame:frame];
    if (self) {
        [self setups];
    }
    return self;
}


///账单状态 已还清0/应还1/还款中2/逾期3
- (void)setStatusModel:(QGRepaymentBillModel *)statusModel
{
    _statusModel = statusModel;
    if (statusModel.status == 0) {
        self.status = [statusModel.amount floatValue] > 0 ? RepaymentStatusPayOff:RepaymentStatusNoPaied;
    }else if (statusModel.status == 1){
        self.status = RepaymentStatusStayPay;
    }else if (statusModel.status == 2){
        self.status = RepaymentStatusPaying;
    }else if (statusModel.status == 3){
        self.status = RepaymentStatusOverDue;
    }else if (statusModel.status == -1){
        self.status = RepaymentStatusSpecOverdue;
    }else {
        self.status = RepaymentStatusNoPaied;
    }
}

- (void)setStatus:(RepaymentStatus)status
{
    _status = status;
    [self updateContentWithStatus:status];
}

#pragma mark - 设置样式

/**
 根据Status设置状态样式

 @param status  RepaymentStatus
 */
- (void)updateContentWithStatus:(RepaymentStatus)status
{
    switch (status) {
        case RepaymentStatusPayOff:
        {
            self.textLab.text = @"本月账单已还清";
            self.textLab.font = [UIFont qg_regularFontOfSize:25.0f];
            self.subTextLab.text = @"赞，本月账单全部还清~";
            self.titleLab.hidden = YES;
            self.textLab.hidden = NO;
            self.subTextLab.hidden = NO;
            self.warningLab.hidden = YES;
            self.imageView.image = [UIImage imageNamed:@"repayment_payoff"];
            self.showDetail.hidden = YES;
            [self.imageView mas_updateConstraints:^(MASConstraintMaker *make) {
                make.centerY.equalTo(self);
            }];
        }
            break;
        case RepaymentStatusStayPay:
        {
            self.titleLab.text = @"剩余待还（元）";
            self.textLab.text = self.statusModel.balanceAmount;
            self.textLab.font = [UIFont qg_numberFontOfSize:30.0f];
            NSDate *date = [NSDate dateWithTimeIntervalSince1970:self.statusModel.lastDay/1000];
            NSString *deadlineDay = [[QGCalendarManager shareInstance] getStringFromDate:date formatter:@"M月d日"];
            self.subTextLab.text = [NSString stringWithFormat:@"最后还款日%@，请在还款日前还款",deadlineDay];
            self.titleLab.hidden = NO;
            self.textLab.hidden = NO;
            self.subTextLab.hidden = NO;
            self.warningLab.hidden = YES;
            self.imageView.image = nil;
            self.showDetail.hidden = NO;
            [self.imageView mas_updateConstraints:^(MASConstraintMaker *make) {
                make.centerY.equalTo(self);
            }];
        }
            break;
        case RepaymentStatusOverDue:
        {
            self.titleLab.text = @"剩余待还（元）";
            self.textLab.text = self.statusModel.balanceAmount;
            self.textLab.font = [UIFont qg_numberFontOfSize:30.0f];
            NSDate *date = [NSDate dateWithTimeIntervalSince1970:self.statusModel.lastDay/1000];
            NSString *deadlineDay = [[QGCalendarManager shareInstance] getStringFromDate:date formatter:@"M月d日"];
            self.subTextLab.text = [NSString stringWithFormat:@"最后还款日%@",deadlineDay];
            self.warningLab.text = @"已逾期";
            self.titleLab.hidden = NO;
            self.textLab.hidden = NO;
            self.subTextLab.hidden = NO;
            self.warningLab.hidden = NO;
            self.imageView.image = [UIImage imageNamed:@"repayment_overdue"];
            self.showDetail.hidden = NO;
            [self.imageView mas_updateConstraints:^(MASConstraintMaker *make) {
                make.centerY.equalTo(self).offset(-15);
            }];
            
        }
            break;
        case RepaymentStatusPaying:
        {
            self.titleLab.text = @"剩余待还（元）";
            self.textLab.text = @"还款中...";
            self.textLab.font = [UIFont qg_regularFontOfSize:25.0f];
            NSDate *date = [NSDate dateWithTimeIntervalSince1970:self.statusModel.lastDay/1000];
            NSString *deadlineDay = [[QGCalendarManager shareInstance] getStringFromDate:date formatter:@"M月d日"];
            self.subTextLab.text = [NSString stringWithFormat:@"最后还款日%@，请在还款日前还款",deadlineDay];
            self.titleLab.hidden = NO;
            self.textLab.hidden = NO;
            self.subTextLab.hidden = NO;
            self.warningLab.hidden = YES;
            self.imageView.image = nil;
            self.showDetail.hidden = YES;
            [self.imageView mas_updateConstraints:^(MASConstraintMaker *make) {
                make.centerY.equalTo(self);
            }];
        }
            break;
        case RepaymentStatusNoPaied:
        {
            if (_statusModel.isShould) {
                self.textLab.text = @"暂无应还账单";
            }else{
                self.textLab.text = @"暂无待还账单";
            }
            self.textLab.font = [UIFont qg_regularFontOfSize:25.0f];
            self.subTextLab.text = @"这个月不用担心还享花卡了";
            self.titleLab.hidden = YES;
            self.textLab.hidden = NO;
            self.subTextLab.hidden = NO;
            self.warningLab.hidden = YES;
            self.imageView.image = [UIImage imageNamed:@"repayment_nopay"];
            self.showDetail.hidden = YES;
            [self.imageView mas_updateConstraints:^(MASConstraintMaker *make) {
                make.centerY.equalTo(self);
            }];
        }
            break;
            case RepaymentStatusSpecOverdue:
        {
            self.textLab.text = @"逾期账单未还";
            self.textLab.font = [UIFont qg_regularFontOfSize:25.0f];
            self.subTextLab.text = @"请您优先还款逾期账单！";
            self.titleLab.hidden = YES;
            self.textLab.hidden = NO;
            self.subTextLab.hidden = NO;
            self.warningLab.hidden = YES;
            self.imageView.image = [UIImage imageNamed:@"repayment_overdue"];
            self.showDetail.hidden = YES;
            [self.imageView mas_updateConstraints:^(MASConstraintMaker *make) {
                make.centerY.equalTo(self);
            }];
        }
            break;
            
        default:
            break;
    }
     self.upBtn.hidden = [self hiddenUpBtn];
    
}

- (BOOL)hiddenUpBtn
{
    if (!([self.statusModel.amount floatValue] > 0)) {
        return YES;
    }
    
    if (self.statusModel.repayInfo == nil && self.statusModel.refundInfo == nil) {
        return YES;
    }
    
    return NO;
    
}

#pragma mark - 设置View

- (void)setups
{
    // 标题
    self.titleLab = [UILabel creatLabelWithSuperView:self title:@"" titleFontSize:[UIFont qg_lightFontOfSize:12.0f] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    self.imageView  =[UIImageView creatImageViewWithSuperView:self imageName:nil];
    // 金额
    self.textLab = [UILabel creatLabelWithSuperView:self title:@"" titleFontSize:[UIFont qg_regularFontOfSize:25.0f] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    //这个月不用还了
    self.subTextLab = [UILabel creatLabelWithSuperView:self title:@"" titleFontSize:[UIFont qg_lightFontOfSize:12.0f] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
    // 已逾期
    self.warningLab = [UILabel creatLabelWithSuperView:self title:@"" titleFontSize:[UIFont qg_regularFontOfSize:16.0f] textColor:[UIColor textColorF41C1C] alignment:NSTextAlignmentLeft];
    
    // 上滑或者下拉button
    self.upBtn = [UIButton creatButtonWithSuperView:self title:nil titleFont:[UIFont qg_regularFontOfSize:15.0f] textColor:[UIColor blackColor]];
    [self.upBtn setImage:[UIImage imageNamed:@"repayment_down"] forState:UIControlStateNormal];
    
    [self.upBtn addTarget:self action:@selector(upBtnAction:) forControlEvents:UIControlEventTouchUpInside];
    self.upBtn.hidden = YES;
    
    //查看详情
    self.showDetail = [UIButton creatButtonWithSuperView:self title:@"查看详情" titleFont:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor3333]];
    [self.showDetail setImage:[UIImage imageNamed:@"repayment_right"] forState:UIControlStateNormal];
    [self.showDetail sizeToFit];
    // 重新设置位置，要写在按钮设置图片和文字之后，否则无效
    self.showDetail.titleEdgeInsets = UIEdgeInsetsMake(0, -self.showDetail.imageView.bounds.size.width, 0, self.showDetail.imageView.bounds.size.width);
    self.showDetail.imageEdgeInsets = UIEdgeInsetsMake(0, self.showDetail.titleLabel.bounds.size.width + 6, 0, -self.showDetail.titleLabel.bounds.size.width - 6);
    [self.showDetail addTarget:self action:@selector(showBalanceAmountDetail) forControlEvents:UIControlEventTouchUpInside];
    self.showDetail.hidden = YES;
    
    
    [self.imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(self).inset(20);
        make.centerY.equalTo(self);
        make.width.height.mas_equalTo(100);
    }];
    /// 标题
    [self.titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.top.equalTo(self).inset(20);
        make.height.mas_equalTo(14);
        make.right.greaterThanOrEqualTo(self.imageView.mas_left).offset(8);
    }];

    /// 金额
    [self.textLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.titleLab);
        make.top.equalTo(self).inset(42);
        make.right.greaterThanOrEqualTo(self).inset(8);
    }];
    
    [self.subTextLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.textLab);
        make.top.equalTo(self.textLab.mas_bottom).offset(10);
        make.right.greaterThanOrEqualTo(self.imageView.mas_left).offset(8);
    }];
    
    [self.warningLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.imageView.mas_centerX);
        make.top.equalTo(self.imageView.mas_bottom).offset(4);
    }];
    
    [self.showDetail mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.subTextLab.mas_left);
        make.top.equalTo(self.subTextLab.mas_bottom).offset(20);
    }];
    
    [self.upBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.mas_centerX);
        make.top.greaterThanOrEqualTo(self.warningLab).offset(2);
        make.bottom.equalTo(self).inset(10);
        make.width.mas_equalTo(60);
    }];
}

- (void)upBtnAction:(UIButton *)btn
{
    self.down = !self.down;
    if (self.down) {
        [btn setImage:[UIImage imageNamed:@"repayment_up"] forState:UIControlStateNormal];
    }else{
        [btn setImage:[UIImage imageNamed:@"repayment_down"] forState:UIControlStateNormal];
    }
    if (self.block) {
        self.block(self.down);
    }
}

- (void)resetUpOrDownStatus
{
    self.down = NO;
    [self.upBtn setImage:[UIImage imageNamed:@"repayment_down"] forState:UIControlStateNormal];
}

- (void)hiddenUpOrDownAction:(BOOL)hidden
{
    self.upBtn.hidden = hidden;
}

///待还金额介绍
- (void)showBalanceAmountDetail
{
    if (self.showAmountDetailBolck) {
        self.showAmountDetailBolck();
    }
}


//- (void)setHiddenUp:(BOOL)hiddenUp
//{
//    _hiddenUp = hiddenUp;
//    self.upBtn.hidden = hiddenUp;
//}


@end
