//
//  QGPaymentStatusView.h
//  VirtualPayment
//
//  Created by silicn on 2019/6/20.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "QGRepaymentBillModel.h"


NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, RepaymentStatus){
    RepaymentStatusPayOff,    // 已还清
    RepaymentStatusStayPay,   // 待还款
    RepaymentStatusOverDue,   // 已逾期
    RepaymentStatusPaying,    // 还款中
    RepaymentStatusNoPaied,   // 没有账单
    RepaymentStatusSpecOverdue //特殊逾期账单未还
};

typedef void(^StatusViewBlock)(BOOL isDown);

@interface QGPaymentStatusView : UIView

@property (nonatomic, strong)QGRepaymentBillModel *statusModel;
///当前还款状态
@property (nonatomic, assign)RepaymentStatus status;

///点击上下按钮触发的Action
@property (nonatomic, copy)StatusViewBlock block;

/// 待还金额详情
@property (nonatomic, copy) dispatch_block_t showAmountDetailBolck;

/**
 复原状态  非内部操作
 */
- (void)resetUpOrDownStatus;


@end

NS_ASSUME_NONNULL_END
