//
//  QGMonthSegmentView.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/20.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGMonthSegmentView.h"
#import "QGBasicUITool.h"

@interface QGMonthSegmentView ()
/// 下划线
@property (nonatomic, strong)UIView *bottomLine;
///上次约束的button
@property (nonatomic, strong)UIButton *preBtn;
/// 上次选择的button
@property (nonatomic, strong)UIButton *preSelectBtn;


@end

@implementation QGMonthSegmentView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setups];
    }
    return self;
}


- (void)setups
{
    
    /// 清空之前视图
    for (id obj in self.subviews) {
        if ([obj isMemberOfClass:[UIButton class]]) {
            [obj removeFromSuperview];
        }
    }
    [self.bottomLine removeFromSuperview];
    self.preBtn = nil;
    
    if (self.titles.count == 0) return;
    
    for (int i = 0; i < self.titles.count; i++) {
        UIButton *btn  = [UIButton creatButtonWithSuperView:self title:self.titles[i] titleFont:[UIFont qg_regularFontOfSize:15.0f] textColor:[UIColor whiteColor]];
        [btn addTarget:self action:@selector(selectBtnAction:) forControlEvents:UIControlEventTouchUpInside];
        btn.tag = 1000 + i;
        [btn mas_makeConstraints:^(MASConstraintMaker *make) {
            if (self.preBtn == nil) {
                make.left.equalTo(self);
            }else{
                make.left.equalTo(self.preBtn.mas_right).offset(10);
                make.width.equalTo(self.preBtn.mas_width);
            }
            make.top.bottom.equalTo(self);
        }];
        self.preBtn = btn;
    }
    
    [self.preBtn mas_updateConstraints:^(MASConstraintMaker *make) {
        make.right.equalTo(self);
    }];
    /// 底部线
    self.bottomLine = [UIView creatViewWithSuperView:self backgroundColor:[UIColor whiteColor]];
    
    UIButton *btn = [self viewWithTag:1000];
    CGFloat length = [self lengthForText:btn.currentTitle];
    
    [self.bottomLine mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(btn.mas_centerX);
        make.width.mas_equalTo(length);
        make.height.mas_equalTo(2);
        make.bottom.equalTo(self).inset(10);
    }];
     btn.selected = YES;
    self.preSelectBtn = btn;
   
    
    
}

- (void)selectBtnAction:(UIButton *)btn
{
     CGFloat length = [self lengthForText:btn.currentTitle];
    [self.bottomLine mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(btn.mas_centerX);
        make.width.mas_equalTo(length);
        make.height.mas_equalTo(2);
        make.bottom.equalTo(self).inset(10);
    }];
    [UIView animateWithDuration:0.25 animations:^{
        [self layoutIfNeeded];
    }];
    if (self.selectBlock) {
        self.selectBlock(btn.tag - 1000);
    }
}

/**
 计算title的length == bottomLine的width

 @param text button的Title
 @return CGFloat  bottomLine的width
 */
- (CGFloat)lengthForText:(NSString *)text
{
    CGSize size = [text boundingRectWithSize:CGSizeMake(MAXFLOAT, 20) options:NSStringDrawingUsesLineFragmentOrigin attributes:@{NSFontAttributeName:[UIFont qg_regularFontOfSize:15.0f]} context:nil].size;
    return size.width;
}

- (UIView *)bottomLine
{
    if (!_bottomLine) {
        _bottomLine = [[UIView alloc]init];
        _bottomLine.backgroundColor = [UIColor whiteColor];
    }
    
    return _bottomLine;
}

- (void)setTitles:(NSArray *)titles
{
    _titles = titles;
    if (titles.count) {
         [self setups];
    }
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
