//
//  QGHitTestView.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/21.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGHitTestView.h"

@implementation QGHitTestView

- (id)init
{
    self = [super init];
    if (self) {
    }
    return self;
}

- (UIView *)hitTest:(CGPoint)point withEvent:(UIEvent *)event
{
//    NSLog(@"QGHitTestView");
    UIView *view = [super hitTest:point withEvent:event];
    if (view == nil && self.canClick) {
        for (UIView *subView in self.subviews) {
            CGPoint tp = [subView convertPoint:point fromView:self];
            if (CGRectContainsPoint(subView.bounds, tp)) {
                view = subView;
            }
        }
    }
    return view;
}

- (BOOL)pointInside:(CGPoint)point withEvent:(UIEvent *)event
{
 
    if (CGRectContainsPoint(self.bounds, point)) {
        return YES;
    }
    return self.canClick;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
