//
//  QGRepaymentShouldBillModel.h
//  VirtualPayment
//
//  Created by silicn on 2019/6/25.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBaseModel.h"

NS_ASSUME_NONNULL_BEGIN
@class QGRepayAmountDetailModel;

@interface QGRepaymentBillModel : QGBaseModel

///账单No
@property (nonatomic, copy) NSString *billNo ;
///账单总额 这个金额如果为0就是没有账单
@property (nonatomic, copy) NSString *amount ;
///当前剩余还款金额
@property (nonatomic, copy) NSString *balanceAmount;
///最后还款日
@property (nonatomic, assign) double lastDay ;
///年
@property (nonatomic, copy) NSString *year ;
///月份
@property (nonatomic, copy) NSString *month ;
///账单状态 已还清0/应还1/还款中2/逾期3   -1 状态为自定义值 ，特殊逾期账单未还状态
@property (nonatomic, assign) NSInteger status;
///消费订单 普通未分期账单
@property (nonatomic, copy) NSArray *amortizeOrderList ;
///已分期订单
@property (nonatomic, copy)NSArray *noAmortizeOrderList;
///逾期账单
@property (nonatomic, copy) NSArray *overdueBillList ;
///还款信息
@property (nonatomic, copy) NSDictionary *repayInfo ;
///分期信息
@property (nonatomic, copy) NSDictionary *installmentInfo ;
/// 退款信息 {amount:@"",url:@""}
@property (nonatomic, copy) NSDictionary *refundInfo;

/// 应还金额明细
@property (nonatomic, strong) QGRepayAmountDetailModel * repayAmountDetail;
///入账周期
@property (nonatomic, strong) NSString * billTradeCycle;


//ext 额外添加字段，和网络数据无关

/// 是否是应还界面的Model
@property (nonatomic, assign) BOOL isShould;


@end




/// 应还金额明细
@interface QGRepayAmountDetailModel : QGBaseModel

/// 每期分期本金
@property (nonatomic, strong) NSString * perTermAmount;

/// 每期分期手续费
@property (nonatomic, strong) NSString * perTermFee;

/// 每期分期手续费详情描述
@property (nonatomic, strong) NSString * perTermFeeDesc;

/// 逾期手续费
@property (nonatomic, strong) NSString * overdueFee;

/// 逾期手续费详情描述
@property (nonatomic, strong) NSString * overdueFeeDesc;

/// 最后还款日
@property (nonatomic, strong) NSString * planRepayDate;

/// 实际还款日
@property (nonatomic, strong) NSString * realRepayDate;



@end

NS_ASSUME_NONNULL_END
