//
//  QGRepaymentViewController.h
//  VirtualPayment
//
//  Created by silicn on 2019/6/19.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBaseTableViewController.h"

@class QGRepaymentBillModel,QGRepaymentBillHeadModel;


NS_ASSUME_NONNULL_BEGIN

@interface QGRepaymentViewController :QGBaseTableViewController

/// 标识是否需要下移Navgation的高度 默认是No，所以跳转必须设置
@property (nonatomic, assign) BOOL shouldExtInsets;

/// 账单头部Model，包含待还金额，还款状态
@property (nonatomic, strong)QGRepaymentBillHeadModel *billHead;

/// 账单列表Model 包含账单列表、订单列表、分期列表
@property (nonatomic, strong) QGRepaymentBillModel *billModel;
/// 应还页面账单的应还金额，
@property (nonatomic, copy)NSString *shouldAmount;

/// 账单Id, 如果billHead和BillModel为空，会根据billId重新请求数据
@property (nonatomic, copy) NSString *billId;
/// 年月，没有账单Id的时候，保险传递字段
@property (nonatomic, copy) NSString *yearMonth;

/// 是否开启监听Scroll事件 ,如果是YES,scroll事件会传递到ScrollListener里面
@property (nonatomic, assign) BOOL listenScroll;


@end

NS_ASSUME_NONNULL_END
