//
//  QGRepaymentGroupViewController.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/26.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGRepaymentGroupViewController.h"
#import "QGRepaymentViewController.h"
#import "QGRepamentHistoryListViewController.h"
//views
#import "QGMonthSegmentView.h"
#import "QGPaymentStatusView.h"
#import "QGGradientView.h"
#import "QGRepaymentPieView.h"
#import "QGRepaymentBottomView.h"
#import "QGRepaymentListView.h"
#import "QGrepaymentSectionView.h"
//cells
#import "QGRepaymentOrderListCell.h"
#import "QGRepaymentStagesViewCell.h"
#import "QGRepaymentSectionCell.h"
#import "QGRepaymentOverDueCell.h"
//networking
#import "QGRepaymentReuestApi.h"
//models
#import "QGRepaymentBillHeadModel.h"
#import "QGRepaymentBillModel.h"
#import "QGRepaymentAmortizeOrderModel.h"
#import "QGRepaymentOverdueModel.h"
//listener
#import "QGRepaymentScollListener.h"
//commons
#import "QGHUDManager.h"

#import "QGUserInfo.h"


#define kScreenWidth [UIScreen mainScreen].bounds.size.width

@interface QGRepaymentGroupViewController ()

/// 客服按钮
@property (nonatomic, strong) UIButton * serviceButton;

///容器ScrolView
@property (nonatomic, strong)UIScrollView *scrollView;
///monthSegment的渐变背景
@property (nonatomic, strong)QGGradientView *gradienView ;
///月份Segment
@property (nonatomic, strong) QGMonthSegmentView *monthSegment ;
///应还
@property (nonatomic, strong) QGRepaymentViewController *shouldVC ;
///待还
@property (nonatomic, strong) QGRepaymentViewController *waitVC ;
///历史账单
@property (nonatomic, strong) QGRepamentHistoryListViewController *historyVC ;
///账单头部
@property (nonatomic, strong) QGRepaymentBillHeadModel *billHead;
/// 应还账单
@property (nonatomic, strong) QGRepaymentBillModel *shouldBill;
/// 待还账单
@property (nonatomic, strong) QGRepaymentBillModel *waitBill;

@property (nonatomic, assign) NSInteger selectIndex;


@end

@implementation QGRepaymentGroupViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setNavBarBackgroundAlpha:0];
    [self setStatuBarLightContent:YES];
    [self custemLeftWhiteBarButtonItem];
    [self setupUI];
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(reloadRequestMehtod) name:VCCRepaymentReloadNotification object:nil];
    
    // Do any additional setup after loading the view.
}


- (void)reloadRequestMehtod
{
    [self requestDataNeedLoading:NO];
}

- (void)setupUI
{
    //添加客服按钮
    self.serviceButton = [self custemRightBarButtonItemWithTitle:nil imageName:@"service_right_barbutton_white" action:^(UIButton * _Nonnull button) {
        [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGBaseWebViewController) parameters:@{@"urlString":VCCServiceUrl} handlerBlock:nil];
    }];
    
    // 渐变背景
    QGGradientView *gradienView = [[QGGradientView alloc]init];
    [self.view addSubview:gradienView];
    self.gradienView = gradienView;
    
    [gradienView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.view.mas_top);
        make.left.right.equalTo(self.view);
        make.width.equalTo(self.view);
        make.height.mas_equalTo(48 + [DeviceAdaptation getNavBarAndStatusBarHeight]);
    }];
    // 月份选择以及历史账单
    QGMonthSegmentView *month = [[QGMonthSegmentView alloc]init];
    [gradienView addSubview:month];
    self.monthSegment = month;
    [month mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(gradienView).inset([DeviceAdaptation getNavBarAndStatusBarHeight]);
        make.left.right.bottom.equalTo(gradienView);
        make.height.mas_equalTo(48);
    }];
    
    // 添加背景视图
    UIView *navBackView = [UIView creatViewWithSuperView:self.view backgroundColor:[UIColor clearColor]];
    [gradienView addSubview:navBackView];
    
    [navBackView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(gradienView.mas_top).inset([DeviceAdaptation getStatusBarHeight]);
        make.left.right.equalTo(gradienView);
        make.height.mas_equalTo(44);
    }];
    // 添加标题
    UILabel *titleLab = [UILabel creatLabelWithSuperView:gradienView title:@"我的账单" titleFontSize:[UIFont qg_mediumFontOfSize:17.0f] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
    [navBackView addSubview:titleLab];

    [titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(navBackView);
        make.centerY.equalTo(navBackView);
    }];
    
    __weak typeof(self) weakSelf = self;
    month.selectBlock = ^(NSInteger index) {
        weakSelf.selectIndex = index;
        [weakSelf.scrollView setContentOffset:CGPointMake(kScreenWidth * index, 0) animated:YES];
    };

    // 视图容器:  |View|View|View|
    self.scrollView = [[UIScrollView alloc]init];
    [self.view addSubview:_scrollView];
    
    [_scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(gradienView.mas_bottom);
        make.left.right.bottom.equalTo(self.view);
    }];
    
    _scrollView.contentSize = CGSizeMake(kScreenWidth * 3,self.scrollView.frame.size.height);
    _scrollView.pagingEnabled = YES;
    _scrollView.bounces = NO;
    _scrollView.backgroundColor = [UIColor whiteColor];
    _scrollView.bouncesZoom = NO;
    _scrollView.scrollEnabled = NO;
    
    /// 应还子视图
    QGRepaymentViewController *shouldVC = [[QGRepaymentViewController alloc]init];
    shouldVC.listenScroll = YES;
    [self addChildViewController:shouldVC];
    [_scrollView addSubview:shouldVC.view];
    self.shouldVC  = shouldVC;
    /// 待还子视图
    QGRepaymentViewController *waitVC = [[QGRepaymentViewController alloc]init];
    waitVC.listenScroll = YES;
    [self addChildViewController:waitVC];
    [_scrollView addSubview:waitVC.view];
    self.waitVC = waitVC;
    /// 历史账单
    QGRepamentHistoryListViewController *historyVC = [[QGRepamentHistoryListViewController alloc]init];
    [self addChildViewController:historyVC];
    [_scrollView addSubview:historyVC.view];
    self.historyVC = historyVC;
    
    [shouldVC.view mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.top.width.height.equalTo(self.scrollView);
    }];
    
    [waitVC.view mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(shouldVC.view.mas_right);
        make.top.width.height.equalTo(self.scrollView);
    }];
    
    [historyVC.view mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(waitVC.view.mas_right);
        make.top.width.height.equalTo(self.scrollView);
    }];
    /// 请求网络
    [self requestDataNeedLoading:YES];
    
    /// MonthSegment 与三个TableView的联动监听，MonthSegment固定高度40
    [self listenScrollWith:gradienView];
    
    
}


/**
 监听shouldVC,WaitVC,historyVC三个子视图的滑动事件

 @param gradienView gradienView（子视图：monthSegment）,使monthSegment向上滑动
 */
- (void)listenScrollWith:(QGGradientView *)gradienView
{
    @weakify(gradienView);
    [QGRepaymentScollListener shareInstance].scrollBlock = ^(CGPoint point) {
        @strongify(gradienView);
        CGFloat scrollHeight = 40 + [DeviceAdaptation getNavBarAndStatusBarHeight];
        CGFloat offset = point.y;
        // monthSegment 和Scroll事件联动
        if (point.x <= CGFLOAT_MIN && offset < scrollHeight) {
            [gradienView mas_updateConstraints:^(MASConstraintMaker *make) {
                make.top.equalTo(self.view.mas_top).inset(-ceilf(offset));
            }];
        }else if (point.x <= CGFLOAT_MIN && offset > scrollHeight){
            [gradienView mas_updateConstraints:^(MASConstraintMaker *make) {
                make.top.equalTo(self.view.mas_top).inset(-scrollHeight);
            }];
        }
        //0 - 1
        CGFloat alpha = MAX(MIN(offset/scrollHeight, 1), 0);
        //设置导航栏的透明度
        [self setNavBarBackgroundAlpha:alpha];
        // 根据透明度设置状态栏的颜色
        if (alpha > 50/scrollHeight) {
            [self setStatuBarLightContent:NO];
            if (self.title == nil) {
                self.title = @"我的账单";
                [self custemLeftDefaultBarButtonItem];
                [self.serviceButton setImage:[UIImage imageNamed:@"service_right_barbutton"] forState:UIControlStateNormal];
            }
        }else{
            [self setStatuBarLightContent:YES];
            self.title = nil;
            [self custemLeftWhiteBarButtonItem];
            [self.serviceButton setImage:[UIImage imageNamed:@"service_right_barbutton_white"] forState:UIControlStateNormal];
        }
    };
}

- (void)requestDataNeedLoading:(BOOL)needLoading
{
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    if (needLoading) [QGHUDManager showHud:@""];
//    NSString * urlString = @"http://yapi.quantgroups.com/mock/169/vcc/order_merge";
    NSString * urlString = [QGRepaymentReuestApi urlWithIndex:QGRepaymentRequestServerMethodGroupMerge];
    [networking GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
       [QGHUDManager hideHud];
        // Request Success
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *data = responseObject[@"data"];
            NSDictionary *billhead = data[@"billHead"];
            //头部更新
            self.billHead = [QGRepaymentBillHeadModel yy_modelWithDictionary:billhead];
            [self updateTableViewHeadSegment];
            // 应还model
            self.shouldBill = [QGRepaymentBillModel yy_modelWithDictionary:data[@"shouldBill"]];
            self.shouldBill.isShould = YES;
            
            // 待还model
            self.waitBill  = [QGRepaymentBillModel yy_modelWithDictionary:data[@"awaitBill"]];
        }else{
           [QGHUDManager showHudWithError:responseObject];
        }
        
        [self updateTableViewSource];
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
         [QGHUDManager hideHud];
        // 添加网络不好的视图
        QGDefaultView * view = [QGDefaultView defaultViewShowWithSuperView:self.view inset:UIEdgeInsetsMake([DeviceAdaptation getNavBarAndStatusBarHeight], 0, 0, 0) reloadBlock:^{
            //开始下拉刷新
            [self requestDataNeedLoading:YES];
        }];
        view.viewType = QGDefaultViewTypeBadNetwork;
    }];
}

/**
 更新MonthSegment.即应还、待还、历史账单
 */
- (void)updateTableViewHeadSegment
{
    //更新头部Segment,默认为三个，本月应还、下月待还、历史账单
    NSMutableArray *billHeads = [NSMutableArray array];
    if (self.billHead.shouldBillDesc) {
        [billHeads addObject:self.billHead.shouldBillDesc];
    }else{
        [billHeads addObject:@"本月应还"];
    }
    if (self.billHead.awaitBillDesc) {
        [billHeads addObject:self.billHead.awaitBillDesc];
    }else{
        [billHeads addObject:@"下月待还"];
    }
    [billHeads addObject:@"历史账单"];
    self.monthSegment.titles = billHeads;
}

- (void)updateTableViewSource
{
    self.shouldVC.billHead = self.billHead;
    self.shouldVC.billModel = self.shouldBill;
    // needShowAwaitBill 为false时，显示特殊逾期页面
    if (self.billHead.shouldBillOverdueFlag) {
        self.waitBill.status = -1;
    }
    self.waitVC.billHead = self.billHead;
    self.waitVC.billModel = self.waitBill;
    self.waitVC.shouldAmount = self.shouldBill.balanceAmount;
    
    [self.scrollView setContentOffset:CGPointMake(0, 0) animated:YES];
    
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
}

/**
 检查入参是否正确 需要子类重写
 
 @param param 入参
 @return 返回参数检查是否通过
 */
- (BOOL)checkParameters:(NSDictionary *)param {
    return YES;
}

- (void)dealloc
{
    if (_scrollView) {
        _scrollView.delegate = nil;
    }
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
