//
//  QGRepamentHistoryListViewController.m
//  VirtualPayment
//
//  Created by silicn on 2019/6/27.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGRepamentHistoryListViewController.h"
#import "QGRepaymentViewController.h"
//cells
#import "QGRepaymentHistoryListCell.h"
//views
#import "QGrepaymentSectionView.h"
#import "QGDefaultView.h"

#import "QGRepaymentReuestApi.h"

//models
#import "QGRepaymentHistoryModel.h"
#import "QGRepaymentHistorySectionModel.h"
//listener
#import "QGRepaymentScollListener.h"

@interface QGRepamentHistoryListViewController ()<UITableViewDelegate,UITableViewDataSource>

@property (nonatomic, strong)NSMutableArray *sectionArray;

@end

@implementation QGRepamentHistoryListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.title = @"历史账单";
    [self custemLeftWhiteBarButtonItem];
    [self setupUI];

}

- (void)setupUI
{
    self.tableViewStyle = UITableViewStyleGrouped;
    [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.view);
    }];
    self.tableView.bounces = NO;
    self.tableView.estimatedRowHeight = 60;
    self.tableView.estimatedSectionFooterHeight = 0;
    self.tableView.estimatedSectionHeaderHeight = 0;
    self.tableView.tableFooterView = [[UIView alloc]init];

    [self requestHistoryList];
}


/**
 网络请求
 */
- (void)requestHistoryList
{
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    
//    NSString * urlString = @"http://yapi.quantgroups.com/mock/169/vcc/history_bills";
    NSString * urlString = [QGRepaymentReuestApi urlWithIndex:QGRepaymentRequestServerMethodHistoryBills];
    [networking GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *data = responseObject[@"data"];
            NSArray *list = data[@"historyBillList"];
            for (NSDictionary *dic in list) {
                QGRepaymentHistoryModel *model = [QGRepaymentHistoryModel yy_modelWithJSON:dic];
                QGRepaymentHistorySectionModel *sectionModel = nil;
                for (QGRepaymentHistorySectionModel *section in self.sectionArray) {
                    if ([section.year isEqualToString:model.billYear]) {
                        sectionModel = section;
                        break;
                    }
                }
                if (sectionModel) {
                    [sectionModel.list addObject:model];
                }else{
                    sectionModel = [[QGRepaymentHistorySectionModel alloc]init];
                    sectionModel.year = model.billYear;
                    [sectionModel.list addObject:model];
                    [self.sectionArray addObject:sectionModel];
                }
            }
            if (self.sectionArray.count == 0) {
                [self addEmptyDefaultView];
            }else{
                self.tableView.backgroundView = nil;
            }
            [self.tableView reloadData];
        }else{
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        QGDefaultView * view = [QGDefaultView defaultViewShowWithSuperView:self.view reloadBlock:^{
            //开始下拉刷新
            [self requestHistoryList];
        }];
        view.viewType = QGDefaultViewTypeBadNetwork;
    }];
}


/**
 增加暂无账单视图
 */
- (void)addEmptyDefaultView
{
    QGDefaultView *backgroundView = [QGDefaultView defaultViewShowWithSuperView:nil reloadBlock:NULL];
    backgroundView.reloadButton.hidden = YES;
    [backgroundView setIconImageWithImageName:@"repayment_empty_nomal" messageTitle:@"暂无账单" buttonTitle:@"刷新"];
    self.tableView.backgroundView = backgroundView;
    [backgroundView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.tableView);
        make.width.height.equalTo(self.tableView);
    }];
}

- (void)scrollViewDidScroll:(UIScrollView *)scrollView
{
    [QGRepaymentScollListener shareInstance].scrollBlock(scrollView.contentOffset);
}

- (CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section
{
    return CGFLOAT_MIN;
}


- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 50;
}


- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    QGrepaymentSectionView *sectionView = [[QGrepaymentSectionView alloc]init];
    QGRepaymentHistorySectionModel *sectionModel = self.sectionArray[section];
    sectionView.title = [NSString stringWithFormat:@"%@年",sectionModel.year];
    sectionView.open = sectionModel.open;
    @weakify(sectionModel);
    @weakify(self);
    sectionView.touchBlock = ^{
        @strongify(sectionModel);
        @strongify(self);
        sectionModel.open = !sectionModel.open;
        [self.tableView reloadSections:[NSIndexSet indexSetWithIndex:section] withRowAnimation:UITableViewRowAnimationNone];
    };
    return sectionView;
}

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return self.sectionArray.count;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    QGRepaymentHistorySectionModel *sectionModel = self.sectionArray[section];
    if (sectionModel.open) {
        return sectionModel.list.count;
    }
    return 0;
}

// Row display. Implementers should *always* try to reuse cells by setting each cell's reuseIdentifier and querying for available reusable cells with dequeueReusableCellWithIdentifier:
// Cell gets various attributes set automatically based on table (separators) and data source (accessory views, editing controls)

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    QGRepaymentHistoryListCell * cell = (QGRepaymentHistoryListCell *)[self getCellFromClassName:NSStringFromClass([QGRepaymentHistoryListCell class]) dequeueTableView:tableView];
    QGRepaymentHistorySectionModel *sectiomModel = self.sectionArray[indexPath.section];
    QGRepaymentHistoryModel *model = sectiomModel.list[indexPath.row];
    cell.model = model;
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    QGRepaymentHistorySectionModel *sectionModel = self.sectionArray[indexPath.section];
    QGRepaymentHistoryModel *model = sectionModel.list[indexPath.row];
    
    [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGRepaymentViewController) isPush:YES parameters:@{@"billId":model.billNo,@"shouldExtInsets":@(YES),@"isHiddenBottom":@(YES)} handlerBlock:^(NSString *tag, NSDictionary *parameters) {
        
    }];
}

- (NSMutableArray *)sectionArray
{
    if (!_sectionArray) {
        _sectionArray = [NSMutableArray array];
    }
    return _sectionArray;
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
