//
//  QGRepaymentCommitViewController.m
//  VirtualPayment
//
//  Created by silicn on 2020/5/22.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGRepaymentCommitViewController.h"
#import "QGPayCardViewCell.h"
#import "QGGradientShadowButton.h"
#import "QGAlertView.h"
#import "QGDepositPwdManager.h"
#import "QGDepositeCardModel.h"
#import "QGRepaymentReuestApi.h"
#import "QGRepayResultViewController.h"
#import "CWWebViewController.h"

@interface QGRepaymentCommitViewController ()<UITableViewDelegate,UITableViewDataSource>

@property (nonatomic, strong)UITableView *tableView;

@property (nonatomic, strong) UIView *headerView ;
///还款名字
@property (nonatomic, strong) UILabel *payNameLab ;
///金额
@property (nonatomic, strong) UILabel *amountLab ;
/// 还款账单描述
@property (nonatomic, strong) UILabel *payDesLab ;

/// 银行名字
@property (nonatomic, copy) NSString *bankName ;
/// 银行尾号
@property (nonatomic, copy) NSString *bankCardTailNo ;
/// 银行编码
@property (nonatomic, copy) NSString *bankCode ;
/// 每单限额
@property (nonatomic, assign) CGFloat bankLimitAmtPerDay;
/// 每日限额
@property (nonatomic, assign) CGFloat bankLimitAmtPerTrade;
///卡id
@property (nonatomic, copy) NSString *cardId ;
/// 卡列表URL
@property (nonnull, copy) NSString *bankCardListH5Url;
/// 还款-提前还款  0:还款1：提前还款
@property (nonatomic, assign) NSInteger repayType;
///还款金额
@property (nonatomic, assign) CGFloat repayAmt;
/// 账单号
@property (nonatomic, copy) NSString *billNumber ;


@end

@implementation QGRepaymentCommitViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    if (param[@"repayType"]) {
        return YES;
    }
    return NO;
}

- (void)transferParameters:(NSDictionary *)param
{
    self.repayType = [param[@"repayType"] integerValue];
    self.billNumber = param[@"billNumber"];
}


- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self custemLeftDefaultBarButtonItem];
    [self setNavBarBottomLineHidden:YES];
    self.title = @"还款";
    
    [self initNomalUI];
    
    // Do any additional setup after loading the view.
}

- (void)initNomalUI
{
    [self.view addSubview:self.tableView];
    
    [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
        if (@available(iOS 11.0, *)) {
            make.top.equalTo(self.view.mas_safeAreaLayoutGuideTop);
        } else {
            make.top.equalTo(self.view).inset(64);
        }
        make.left.right.bottom.equalTo(self.view);
    }];
    self.headerView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, 140)];
    self.headerView.backgroundColor = UIColor.whiteColor;
    UILabel *payNameLab = [UILabel creatLabelWithSuperView:self.headerView title:@"应还金额(元)" titleFontSize:[UIFont qg_lightFontOfSize:12.0f] textColor:UIColor.textColor9999 alignment:NSTextAlignmentCenter];
    [payNameLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.inset(30);
        make.centerX.equalTo(self.headerView);
    }];
    self.payNameLab = payNameLab;
    
    UILabel *amountLab = [UILabel creatLabelWithSuperView:self.headerView title:@"0.00" titleFontSize:[UIFont qg_numberFontOfSize:30.0f] textColor:UIColor.textColor3333 alignment:NSTextAlignmentCenter];
    [amountLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(payNameLab.mas_bottom).offset(12);
        make.centerX.equalTo(payNameLab);
    }];
    self.amountLab = amountLab;
    
    UILabel *payDesLab = [UILabel creatLabelWithSuperView:self.headerView title:@"" titleFontSize:[UIFont qg_lightFontOfSize:12.0f] textColor:UIColor.textColor9999 alignment:NSTextAlignmentCenter];
    payDesLab.numberOfLines = 0;
    [payDesLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(amountLab.mas_bottom).offset(13);
        make.left.right.inset(20);
        make.bottom.lessThanOrEqualTo(self.headerView).inset(10);
    }];
    self.payDesLab = payDesLab;
    
    self.tableView.tableHeaderView = self.headerView;
    
    UIView *footerView = [[UIView alloc]initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, 100)];
    footerView.backgroundColor = UIColor.clearColor;
    
    QGGradientShadowButton *commitBtn = [QGGradientShadowButton creatGradientColorButtonWithSuperView:footerView title:@"确认还款" textFont:[UIFont qg_regularFontOfSize:17.0f]];
    
    [commitBtn addTarget:self action:@selector(commitAction:) forControlEvents:UIControlEventTouchUpInside];

    [commitBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.inset(20);
        make.top.inset(50);
        make.height.mas_equalTo(40);
    }];
    self.tableView.tableFooterView = footerView;
    
    [self requestData];
    
}

#pragma mark - Request

- (void)requestData
{
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    [QGHUDManager showHud:nil];
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    [param setObject:@(self.repayType) forKey:@"repayType"];
    if (self.billNumber) {
        [param setObject:self.billNumber forKey:@"billNumber"];
    }
   // [QGRepaymentReuestApi urlWithIndex:QGRepaymentRequestServerMethodRepayInfo];
    //@"http://yapi.quantgroups.com/mock/305/vcc/repay/page"
    [networking GET:[QGRepaymentReuestApi urlWithIndex:QGRepaymentRequestServerMethodRepayInfo] parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *data = responseObject[@"data"];
            
            self.payNameLab.text = data[@"repayContent"];
            self.amountLab.text =  [NSString stringWithFormat:@"%.2f", [data[@"repayAmt"] floatValue]];
            self.payDesLab.text = data[@"billTotalAmtContent"];
            self.bankName = data[@"bankName"];
            self.bankCardTailNo = data[@"bankCardTailNo"];
            self.bankCode = data[@"bankCode"];
            self.bankLimitAmtPerDay = [data[@"bankLimitAmtPerDay"] floatValue];
            self.bankLimitAmtPerTrade = [data[@"bankLimitAmtPerTrade"] floatValue];
            self.bankCardListH5Url = data[@"bankCardListH5Url"];
            self.repayType = [data[@"repayType"] integerValue];
            self.cardId = [NSString stringWithFormat:@"%@",data[@"bankCardId"]];
            self.repayAmt =[data[@"repayAmt"] floatValue];
            [self.tableView reloadData];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager hideHud];
        QGDefaultView * view = [QGDefaultView defaultViewShowWithSuperView:self.view inset:UIEdgeInsetsMake([DeviceAdaptation getNavBarAndStatusBarHeight], 0, 0, 0) reloadBlock:^{
            //开始下拉刷新
            [self requestData];
        }];
        view.viewType = QGDefaultViewTypeBadNetwork;
    }];
    
}

#pragma mark - TableView Delegate & DataSource

- (UIView *)tableView:(UITableView *)tableView viewForHeaderInSection:(NSInteger)section
{
    UIView *view = [[UIView alloc]initWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, 10)];
    view.backgroundColor = UIColor.moduleSeparatorColorF7F7;
    return view;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section
{
    return 10.0f;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 1;
}

// Row display. Implementers should *always* try to reuse cells by setting each cell's reuseIdentifier and querying for available reusable cells with dequeueReusableCellWithIdentifier:
// Cell gets various attributes set automatically based on table (separators) and data source (accessory views, editing controls)

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    QGPayCardViewCell *cell = (QGPayCardViewCell *)[self getCellFromClassName:NSStringFromClass([QGPayCardViewCell class]) dequeueTableView:tableView];
    if (self.bankName.length) {
        cell.bankName  = [NSString stringWithFormat:@"%@(%@)",self.bankName,self.bankCardTailNo ? self.bankCardTailNo :@""];
    }else{
        cell.bankName = @"请添加银行卡";
    }
   
    cell.limitDes = [NSString stringWithFormat:@"单笔限额%.f元,单日限额%.f元",self.bankLimitAmtPerTrade,self.bankLimitAmtPerDay];
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    if (self.bankCardListH5Url) {
        QGBaseWebViewController *webVC = [[QGBaseWebViewController alloc]init];
        NSString *appendString = [NSString stringWithFormat:@"?vccToken={token}&bankCode=%@&cardLast=%@",self.bankCode,self.bankCardTailNo];
        webVC.urlString = [self.bankCardListH5Url stringByAppendingString:appendString];
        webVC.callBackBlock = ^(NSString *tag, NSDictionary *params) {
            /// H5选择的银行卡列表
            if ([tag isEqualToString:kWebView_selectBankCardInfoKey]) {
                if (params) {
                    self.bankName = params[@"bankName"];
                    self.cardId = params[@"cardId"];
                    self.bankLimitAmtPerDay = [params[@"dayLimit"] floatValue];
                    self.bankLimitAmtPerTrade = [params[@"tradeLimit"] floatValue];
                    self.bankCardTailNo = params[@"tailCardNo"];
                    self.bankCode = params[@"bankCode"];
                    [self.tableView reloadData];
                }
            }
        };
        [self.navigationController pushViewController:webVC animated:YES];
    }
}


- (void)commitAction:(UIButton *)btn
{
    if (self.repayAmt > self.bankLimitAmtPerTrade) {
        QGAlertView *alert = [[QGAlertView alloc]initWithTitle:nil message:@"您的还款金额已经超过对应银行单笔还款限额，请您更换银行卡还款。" cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:NULL];
        [alert showInView:self.view];
        return;
    }
    
    if (self.cardId == nil || [self.cardId isEqualToString:@""]) {
        [QGHUDManager showHud:@"获取信息错误"];
        return;
    }
    
    QGDepositeCardModel *card = [[QGDepositeCardModel alloc]init];
    card.bankName = self.bankName;
    if (self.bankCardTailNo.length > 4) {
        card.tailCardNo = [self.bankCardTailNo substringWithRange:NSMakeRange(self.bankCardTailNo.length - 4, 4)];
    }else{
        card.tailCardNo = self.bankCardTailNo;
    }
    card.cardId = self.cardId;
    card.minAmount = @"0.00";
    card.maxAmount = [NSString stringWithFormat:@"%.2f",self.bankLimitAmtPerTrade];
    card.billNumber = self.billNumber;
    card.isPreRepay = self.repayType;
    QGDepositPwdManager *manager = [QGDepositPwdManager defaultMangerWithType:QGDepositTypeRepay amount:[NSString stringWithFormat:@"%.2f",self.repayAmt] card:card];
    [manager showInView:self.view];
    
    @weakify(self);
    manager.tradeResultBlock = ^(BOOL success, NSString * _Nullable tradeNo, NSString * _Nullable message) {
        @strongify(self);
        if (success) {
            [self toReslut];
        }
    };
    
}


- (void)toReslut
{
    QGRepayResultViewController *vc = [[QGRepayResultViewController alloc]init];
    [self.navigationController pushViewController:vc animated:YES];
}


- (UITableView *)tableView
{
    if (!_tableView) {
        _tableView = [[UITableView alloc]initWithFrame:CGRectZero style:UITableViewStylePlain];
        _tableView.dataSource = self;
        _tableView.delegate = self;
        _tableView.estimatedRowHeight = 0;
        _tableView.rowHeight = 74;
        _tableView.estimatedSectionFooterHeight = 0;
        _tableView.estimatedSectionHeaderHeight = 0;
        _tableView.backgroundColor = UIColor.moduleSeparatorColorF7F7;
    }
    return _tableView;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
