//
//  QGRepayResultViewController.m
//  VirtualPayment
//
//  Created by silicn on 2020/5/25.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGRepayResultViewController.h"

#import "QGCountDown.h"

#import "QGRepaymentReuestApi.h"

#import "QGGradientShadowButton.h"

@interface QGRepayResultViewController ()

/// 图片
@property (nonatomic, strong)UIImageView *imageView;
/// 时间
@property (nonatomic, strong)UILabel *timeLab;
/// 主提示
@property (nonatomic, strong)UILabel *titleLab;
/// 副提示
@property (nonatomic, strong)UILabel *subTitleLab ;
/// 还款按钮
@property (nonatomic, strong) QGGradientShadowButton *repayBtn ;

/// 计时器
@property (nonatomic, strong) QGCountDown *timer ;
/// 秒数
@property (nonatomic, assign)NSInteger seconds;
/// 页面样式
@property (nonatomic, assign)QGRepayResultViewType viewType;
/// 转账失败错误信息
@property (nonatomic, copy)NSString *errorMsg;


@end

@implementation QGRepayResultViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupNavigation];
    
    [self initNomalUI];
    
    [self initData];
    
    // Do any additional setup after loading the view.
}

- (void)setupNavigation
{
    [self custemLeftDefaultBarButtonItem];
    [self setNavBarBottomLineHidden:YES];
    self.title = @"还款结果";
}

- (void)initNomalUI
{
    /// 图片
    UIImageView *imageView = [[UIImageView alloc]init];
    [self.view addSubview:imageView];
    imageView.image = [UIImage imageNamed:@"deposit_wait"];
    [imageView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.view);
        make.height.width.mas_equalTo(120);
        if (@available(iOS 11.0, *)) {
            make.top.equalTo(self.view.mas_safeAreaLayoutGuideTop).inset(40);
        } else {
            make.top.equalTo(self.view.mas_top).inset(104);
        }
    }];
    self.imageView = imageView;
    /// 时间倒计时
    UILabel *timeLab = [UILabel creatLabelWithSuperView:self.view title:@"15s" titleFontSize:[UIFont qg_mediumFontOfSize:15.0f] textColor:UIColor.yyMainThemeColor alignment:NSTextAlignmentCenter];
    [timeLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.centerY.equalTo(self.imageView);
        make.height.width.mas_equalTo(40);
    }];
    timeLab.hidden = YES;
    self.timeLab  = timeLab;
    /// 正在转入/出
    NSString *title = @"还款中,请稍后…";
    UILabel *titleLab = [UILabel creatLabelWithSuperView:self.view title:title titleFontSize:[UIFont qg_regularFontOfSize:16.0f] textColor:UIColor.textColor3333 alignment:NSTextAlignmentCenter];
    [titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(imageView.mas_bottom).offset(20);
        make.centerX.equalTo(imageView);
    }];
    self.titleLab = titleLab;
    ///温馨提示
    UILabel *subTitleLab = [UILabel creatLabelWithSuperView:self.view title:@" " titleFontSize:[UIFont qg_lightFontOfSize:12.0f] textColor:UIColor.textColor9999 alignment:NSTextAlignmentCenter];
    subTitleLab.numberOfLines = 0;
    [subTitleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(titleLab.mas_bottom).offset(6);
        make.centerX.equalTo(titleLab);
        make.left.right.greaterThanOrEqualTo(self.view).inset(25);
    }];
    self.subTitleLab = subTitleLab;
    
    /// 再转一笔
    self.repayBtn = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.view title:@"返回" textFont:[UIFont qg_regularFontOfSize:17.0]];
    _repayBtn.layer.cornerRadius = 20;
    _repayBtn.layer.borderColor = UIColor.yyMainThemeColor.CGColor;
    _repayBtn.layer.borderWidth = 1;
    _repayBtn.layer.masksToBounds = YES;
    [_repayBtn addTarget:self action:@selector(depositBtnAction:) forControlEvents:UIControlEventTouchUpInside];
    
    [self.repayBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.inset(20);
        make.top.equalTo(self.subTitleLab.mas_bottom).offset(50);
        make.height.mas_equalTo(40);
    }];
   
    self.viewType = QGRepayResultViewTypeWaiting;
}

/// 初始化数据
- (void)initData
{
    self.seconds = 15;
    self.timer = [[QGCountDown alloc]init];
    @weakify(self);
    
    [self.timer countDownWithSEC:1.0f isImmediatelySelector:YES eventBlock:^{
        @strongify(self);
        /// 时间间隔
        static NSInteger interval = 0;
        self.seconds--;
        interval++;
        self.timeLab.text = [NSString stringWithFormat:@"%lus",self.seconds];
        if (self.seconds == 0) {
            [self stopTimer];
            self.viewType = QGRepayResultViewTypeWaiting;
        }
        /// 三秒刷新一次接口
        if (interval == 3) {
            [self queryResult];
            interval = 0;
        }
    }];
}

///成功/失败/处理中,交易状态 0-处理中 1-成功 2-失败
///NONE(0, "None", "未找到支付订单"),

//PROCESSING(1, "Processing", "处理中订单"),
//
//COMPLETE(2, "Complete", "支付完成"),
//
//FAILED(3, "Failed", "支付失败");
/// 查询交易结果
- (void)queryResult
{
    
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    [networking GET:[QGRepaymentReuestApi urlWithIndex:QGRepaymentRequestServerMethodRepayStatus] parameters:nil success:^(id  _Nonnull responseObject) {
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *data = responseObject[@"data"];
            NSInteger status = [data[@"status"] integerValue];
            /// 仅处理成功和失败, status=0 在计时seconds=15的逻辑里
            if (status == 2) {
                [self stopTimer];
                self.viewType = QGRepayResultViewTypeSuccess;
                /// 通知刷新页面
                [[NSNotificationCenter defaultCenter] postNotificationName:VCCRepaymentReloadNotification object:nil];
            }else if (status == 3){
                [self stopTimer];
                self.errorMsg = data[@"failedReason"];
                self.viewType = QGRepayResultViewTypeFailure;
            }
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        
    }];
}

/// 停止计时,并且终止Gif动画
- (void)stopTimer
{
    [self.timer destoryTimer];
}

- (void)setViewType:(QGRepayResultViewType)viewType
{
    if (_viewType != viewType) {
        _viewType = viewType;
        [self refreshViewWithType:viewType];
    }
}



- (void)depositBtnAction:(UIButton *)btn
{
    if (self.actionBlock) {
        self.actionBlock(self.viewType);
    }
    
    if (self.viewType ==  QGRepayResultViewTypeSuccess || self.viewType == QGRepayResultViewTypeWaiting) {
        [self.navigationController popToRootViewControllerAnimated:YES];
    }else{
        [self.navigationController popViewControllerAnimated:YES];
    }
}

#pragma mark - 切换页面样式
/// 切换页面样式
- (void)refreshViewWithType:(QGRepayResultViewType)type
{
    switch (type) {
        case QGRepayResultViewTypeNone:
        {
            self.timeLab.hidden = YES;
            self.imageView.image = [UIImage imageNamed:@"deposit_wait"];
            self.titleLab.text = @"还款中,请稍后…";
            self.subTitleLab.text = nil;
            self.repayBtn.hidden = NO;
            [self.repayBtn setTitle:@"返回" forState:UIControlStateNormal];
        }
            break;
        case QGRepayResultViewTypeSuccess: /// 转账成功
        {
            self.timeLab.hidden = YES;
            self.imageView.image = [UIImage imageNamed:@"deposit_success"];
            self.subTitleLab.text = nil;
            self.titleLab.text = @"还款成功";
            self.repayBtn.hidden = NO;
            [self.repayBtn setTitle:@"完成" forState:UIControlStateNormal];
        }
            break;
        case QGRepayResultViewTypeFailure: /// 转账失败
        {
            self.timeLab.hidden = YES;
            self.imageView.image = [UIImage imageNamed:@"deposit_failure"];
            self.titleLab.text = @"还款失败";
            self.subTitleLab.text = nil;
            self.repayBtn.hidden = NO;
            [self.repayBtn setTitle:@"重新还款" forState:UIControlStateNormal];
        }
            break;
        case QGRepayResultViewTypeWaiting: /// 正在转账
        {
            self.timeLab.hidden = YES;
            self.imageView.image = [UIImage imageNamed:@"deposit_wait"];
            self.titleLab.text = @"还款中,请稍后…";
            self.subTitleLab.text = nil;
            self.repayBtn.hidden = NO;
            [self.repayBtn setTitle:@"返回" forState:UIControlStateNormal];
        }
            break;
            
        default:
            break;
    }
}

- (void)setErrorMsg:(NSString *)errorMsg
{
    if (_errorMsg != errorMsg) {
        _errorMsg = errorMsg;
        self.subTitleLab.text = errorMsg;
    }
}


- (NSArray *)getImages
{
    NSURL *gifImageUrl = [[NSBundle mainBundle] URLForResource:@"count_down" withExtension:@"gif"];
    //获取Gif图的原数据
    CGImageSourceRef gifSource = CGImageSourceCreateWithURL((CFURLRef)gifImageUrl, NULL);
     //获取Gif图有多少帧
    size_t gifcount = CGImageSourceGetCount(gifSource);
    NSMutableArray *images = [[NSMutableArray alloc] init];

    for (NSInteger i = 0; i < gifcount; i++) {
        CGImageRef imageRef = CGImageSourceCreateImageAtIndex(gifSource, i, NULL);
        UIImage *image = [UIImage imageWithCGImage:imageRef];
        [images addObject:image];
        CGImageRelease(imageRef);
    }
    return images;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
