//
//  QGDepositeViewCell.m
//  VirtualPayment
//
//  Created by silicn on 2020/3/31.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGDepositeViewCell.h"
#import "QGBasicUITool.h"

@interface QGDepositeViewCell()



@end

@implementation QGDepositeViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        self.backgroundColor = UIColor.clearColor;
        self.contentView.backgroundColor = UIColor.clearColor;
        [self setups];
    }
    return self;
}

- (void)setups
{
    UIView *backView = [UIView creatViewWithSuperView:self.contentView backgroundColor:UIColor.whiteColor];
    [backView setBorder:[UIColor colorWithHexString:@"#dcdcdc"] width:0.5];
    [backView setShadowColor:[UIColor colorWithHexString:@"#dcdcdc"] shadowRadius:5 shadowOffset:CGSizeMake(0, 3) cornerRadius:5];
    [backView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.inset(20);
        make.top.equalTo(self.contentView);
        make.bottom.inset(10);
    }];
    
    self.imageV = [[UIImageView alloc]init];
    [backView addSubview:_imageV];
    _imageV.layer.cornerRadius = 18;
    _imageV.clipsToBounds = YES;
    _imageV.backgroundColor = [UIColor colorWithHexString:@"#EDEDED"];
    [self.imageV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(10);
        make.width.height.mas_equalTo(36);
        make.top.bottom.inset(16);
    }];
    
    self.titleLab = [UIView creatLabelWithSuperView:backView title:@"转入" titleFontSize:[UIFont qg_mediumFontOfSize:14.0f] textColor:UIColor.textColor3333 alignment:NSTextAlignmentLeft];
    [self.titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.imageV.mas_top).offset(-3);
        make.left.equalTo(self.imageV.mas_right).offset(10);
    }];
    
    self.subTextLab =[UIView creatLabelWithSuperView:backView title:@"从**银行(****)银行卡直接代扣转入" titleFontSize:[UIFont qg_lightFontOfSize:12.0f] textColor:UIColor.textColor9999 alignment:NSTextAlignmentLeft];
    [self.subTextLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.imageV.mas_right).offset(10);
        make.top.equalTo(self.titleLab.mas_bottom).offset(4);
    }];
    
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
