//
//  QGDepositeAmountViewCell.m
//  VirtualPayment
//
//  Created by silicn on 2020/4/1.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGDepositeAmountViewCell.h"
#import "QGBasicUITool.h"
#import "QGDepositeCardModel.h"

@interface QGDepositeAmountViewCell ()<UITextFieldDelegate>

@property (nonatomic, strong) UILabel *titleLab ;

@property (nonatomic, strong) UILabel *tipLab ;

@end

@implementation QGDepositeAmountViewCell

- (void)awakeFromNib {
    [super awakeFromNib];
    // Initialization code
}

- (id)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        self.backgroundColor = UIColor.whiteColor;
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        [self setups];
    }
    return self;
}

- (void)setups
{
    self.padding = 20;
    self.arrowHide = YES;
    self.titleLab = [UILabel creatLabelWithSuperView:self.contentView title:@"金额(元)" titleFontSize:[UIFont qg_lightFontOfSize:16.0f] textColor:UIColor.textColor6666 alignment:NSTextAlignmentLeft];
    [self.titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(20);
        make.centerY.equalTo(self.contentView);
    }];
    
    self.amountTF = [UITextField creatTextFieldWithSuperView:self.contentView placeholder:@"请输入转入金额" titleFontSize:[UIFont qg_regularFontOfSize:16.0f] textColor:UIColor.textColor3333 tintColor:UIColor.yyMainThemeColor clearButtonMode:UITextFieldViewModeNever];
    self.amountTF.delegate = self;
    [self.amountTF addTarget:self action:@selector(textFieldChanged:) forControlEvents:UIControlEventEditingChanged];
    _amountTF.keyboardType = UIKeyboardTypeDecimalPad;
    [self.amountTF mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.titleLab);
        make.right.inset(20);
        make.left.inset(100);
    }];
    
    self.tipLab = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:10.0f] textColor:UIColor.yyMainThemeColor alignment:NSTextAlignmentLeft];
    [self.tipLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self.amountTF);
        make.bottom.inset(3);
    }];
    
}

- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField
{
    if (self.editBeginBlock) {
        self.editBeginBlock();
    }
    return YES;
}

- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string {
    
    
    NSMutableString *futureString = [NSMutableString stringWithString:textField.text];
    [futureString insertString:string atIndex:range.location];
    
    NSInteger flag = 0;
    // 限制两位
    const NSInteger limited = 2;
    
    for (NSInteger i = futureString.length - 1; i >= 0; i--) {
        if ([futureString characterAtIndex:i] == '.') {
            // 如果大于了限制的就提示
            if (flag > limited) {
                return NO;
            }
            break;
        }
        flag++;
    }
    
    return YES;
}

- (void)textFieldChanged:(UITextField *)textField
{
    /// 输入内容,小于最大值,或者大于最小值,且不等于0
    if ([textField.text floatValue] < [self.model.minAmount floatValue] || [textField.text floatValue] == 0 || textField.text.length == 0 ) {
        if (self.amountEditBlock) {
            self.amountEditBlock(NO, textField.text);
        }
        self.tipLab.text = nil;
    }else if ([textField.text floatValue] > [self.model.maxAmount floatValue]){
        if (self.amountEditBlock) {
            self.amountEditBlock(NO, textField.text);
        }
        /// 立即提示
        self.tipLab.text = @"输入金额有误，请重新输入！";
    }else{
        if (self.amountEditBlock) {
            self.amountEditBlock(YES, textField.text);
        }
        self.tipLab.text = nil;
    }
}

- (BOOL)textFieldShouldEndEditing:(UITextField *)textField
{
    /// 输入内容完成是提示
    if (textField.text.length <= 0 || [textField.text floatValue] < [self.model.minAmount floatValue]) {
        if (textField.text.length != 0) {
            self.tipLab.text = @"输入金额有误，请重新输入！";
        }
    }
    return YES;
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
