//
//  QGDepositCourseView.m
//  VirtualPayment
//
//  Created by silicn on 2020/4/1.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGDepositCourseView.h"
#import "QGGradientView.h"

#import "UIImageView+WebCache.h"

#import "QGBasicUITool.h"

#import "QGDepositeCardModel.h"

@interface QGDepositCourseView ()

@property (nonatomic, strong)UIImageView *fromImageV;

@property (nonatomic, strong) UILabel *fromLab ;

@property (nonatomic, strong) UIImageView *toImageV ;

@property (nonatomic, strong) UILabel *toLab ;


@end


@implementation QGDepositCourseView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setups];
    }
    return self;
}

- (void)setups
{
    QGGradientView *gradView = [[QGGradientView alloc]init];
    gradView.layer.cornerRadius = 6;
    gradView.clipsToBounds = YES;
    [self addSubview:gradView];
    [gradView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self);
    }];
    
    UIImageView *courseImageV = [[UIImageView alloc]initWithImage:[UIImage imageNamed:@"deposit_course"]];
    [gradView addSubview:courseImageV];
    
    [courseImageV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(gradView);
        make.centerY.equalTo(gradView).offset(10);
        make.width.mas_equalTo(54);
        make.height.mas_equalTo(8);
    }];
    
    self.fromLab = [UILabel creatLabelWithSuperView:gradView title:@"" titleFontSize:[UIFont qg_regularFontOfSize:12.0f] textColor:UIColor.whiteColor alignment:NSTextAlignmentCenter];
    _fromLab.numberOfLines = 0;
    _fromLab.text = @"****";
    
    [self.fromLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(8);
        make.right.equalTo(courseImageV.mas_left).offset(-8);
        make.top.equalTo(courseImageV.mas_top).offset(-6);
        make.bottom.lessThanOrEqualTo(gradView).inset(10);
    }];
    
    self.toLab = [UILabel creatLabelWithSuperView:gradView title:@"" titleFontSize:[UIFont qg_regularFontOfSize:12.0f] textColor:UIColor.whiteColor alignment:NSTextAlignmentCenter];
    _toLab.numberOfLines = 0;
    _toLab.text = @"****";
    
    [self.toLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.inset(8);
        make.left.equalTo(courseImageV.mas_right).offset(8);
        make.top.equalTo(self.fromLab);
        make.bottom.lessThanOrEqualTo(gradView).inset(10);
    }];
    
    self.fromImageV = [UIImageView creatImageViewWithSuperView:gradView imageName:nil];
    _fromImageV.backgroundColor = [UIColor clearColor];
    _fromImageV.layer.cornerRadius = 14;
    _fromImageV.clipsToBounds = YES;
    
    [self.fromImageV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.fromLab);
        make.width.height.mas_equalTo(28);
        make.bottom.equalTo(self.fromLab.mas_top).offset(-4);
    }];
    
    self.toImageV = [UIImageView creatImageViewWithSuperView:gradView imageName:nil];
    _toImageV.backgroundColor = [UIColor clearColor];
    _toImageV.layer.cornerRadius = 14;
    _toImageV.clipsToBounds = YES;
    [self.toImageV mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(self.toLab);
        make.width.height.mas_equalTo(28);
        make.bottom.equalTo(self.toLab.mas_top).offset(-4);
    }];
    
}

- (void)setFromModel:(QGDepositeCardModel *)fromModel
{
    if (_fromModel != fromModel) {
        _fromModel = fromModel;
        self.fromLab.text = [NSString stringWithFormat:@"%@%@(%@)", fromModel.bankName,fromModel.type,fromModel.tailCardNo];
        [self.fromImageV sd_setImageWithURL:[NSURL URLWithString:fromModel.imgUrl]];
    }
}

- (void)setToModel:(QGDepositeCardModel *)toModel
{
    if (_toModel != toModel) {
        _toModel = toModel;
        self.toLab.text =[NSString stringWithFormat:@"%@%@(%@)", toModel.bankName,toModel.type,toModel.tailCardNo];
        [self.toImageV sd_setImageWithURL:[NSURL URLWithString:toModel.imgUrl]];
    }
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
