//
//  QGPwdTextView.m
//  VirtualPayment
//
//  Created by silicn on 2020/4/2.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGPwdTextView.h"

#import "QGBasicUITool.h"

#import "QGPwdDotView.h"


@interface QGPwdTextView ()

@property (nonatomic, strong)UITextField *textField;

@property (nonatomic, strong)UIView *maskView;

@property (nonatomic, strong)NSMutableArray *dotsArray;


@end

@implementation QGPwdTextView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        _places = 6;
        [self setups];
    }
    return self;
}

- (void)setups
{
    self.textField = [[UITextField alloc]init];
    _textField.keyboardType = UIKeyboardTypeNumberPad;
    _textField.translatesAutoresizingMaskIntoConstraints = NO;
    _textField.borderStyle = UITextBorderStyleNone;
    _textField.clearButtonMode = UITextFieldViewModeNever;
    _textField.autocorrectionType = UITextAutocorrectionTypeNo;
    _textField.contentVerticalAlignment = UIControlContentVerticalAlignmentCenter;
    
    [_textField addTarget:self action:@selector(textFieldEditingChanged:) forControlEvents:UIControlEventEditingChanged];
    
    [self addSubview:_textField];
    
    [self.textField mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self);
    }];
    
    self.maskView = [UIView creatViewWithSuperView:self backgroundColor:UIColor.whiteColor];
    _maskView.userInteractionEnabled = NO;
    _maskView.layer.borderColor = [UIColor colorWithHexString:@"#d8d8d8"].CGColor;
    _maskView.layer.borderWidth = 1;
    _maskView.layer.cornerRadius = 6;
    _maskView.layer.masksToBounds = YES;
    
    [self.maskView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self);
    }];
    
    [self setupPlaces];
}

- (void)textFieldEditingChanged:(UITextField *)textField
{
    if (textField.text.length > self.dotsArray.count) {
        textField.text = [textField.text substringToIndex:self.dotsArray.count];
        return;
    }
    
    if (textField.text.length == 0) {
        [self.dotsArray enumerateObjectsUsingBlock:^(QGPwdDotView *  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
            obj.dotVisible = NO;
        }];
    }else{
        [self.dotsArray enumerateObjectsUsingBlock:^(QGPwdDotView *  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
            obj.dotVisible = idx < textField.text.length ? YES : NO;
        }];
    }
    
    if (textField.text.length == self.dotsArray.count) {
         NSLog(@"输入密码完成");
        if (self.inputBlock) {
            self.inputBlock(YES, textField.text);
        }
        return;
     }
    if (self.inputBlock) {
        self.inputBlock(NO, textField.text);
    }
    
}

- (void)setupPlaces
{
    if (self.places == 0) return;

    [self.maskView.subviews enumerateObjectsWithOptions:NSEnumerationReverse usingBlock:^(__kindof UIView * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        [obj removeFromSuperview];
    }];
    self.dotsArray = [NSMutableArray array];
    
    QGPwdDotView *leftDot = nil;
    for (int i = 0; i < self.places; i++) {
        /// 黑点
        QGPwdDotView *dot = [[QGPwdDotView alloc]init];
        [self.maskView addSubview:dot];
        /// 装入数组
        [self.dotsArray addObject:dot];
        /// 竖线
        UIView *line = [self verticalLine];
        [self.maskView addSubview:line];
        
        if (leftDot) {
            [dot mas_makeConstraints:^(MASConstraintMaker *make) {
                make.left.equalTo(leftDot.mas_right).offset(1);
                make.top.bottom.equalTo(self.maskView);
                make.width.equalTo(leftDot.mas_width);
            }];
            [line mas_makeConstraints:^(MASConstraintMaker *make) {
                make.left.equalTo(leftDot.mas_right);
                make.width.mas_equalTo(1);
                make.top.bottom.equalTo(self.maskView);
            }];
        }else{
            [dot mas_makeConstraints:^(MASConstraintMaker *make) {
                make.left.inset(0);
                make.top.bottom.equalTo(self.maskView);
            }];
            [line mas_makeConstraints:^(MASConstraintMaker *make) {
                make.left.equalTo(dot.mas_right);
                make.width.mas_equalTo(1);
                make.top.bottom.equalTo(self.maskView);
            }];
        }
        leftDot = dot;
    }
    
    if (leftDot) {
        [leftDot mas_updateConstraints:^(MASConstraintMaker *make) {
            make.right.inset(0);
        }];
    }
}

- (void)setPlaces:(NSInteger)places
{
    if (_places != places) {
        _places = places;
         [self setupPlaces];
    }
}

#pragma mark - 自定义方法

- (void)cleanInputContent
{
    [self.dotsArray enumerateObjectsUsingBlock:^(QGPwdDotView *  _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
            obj.dotVisible = NO;
    }];
    self.textField.text = @"";
}

- (void)resignFirstResponder
{
    [self.textField resignFirstResponder];
}

- (void)becomeFirstResponder
{
    [self.textField becomeFirstResponder];
}

- (UIView *)verticalLine
{
    UIView *line = [[UIView alloc]init];
    line.backgroundColor = [UIColor colorWithHexString:@"#d8d8d8"];
    return line;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
