//
//  QGDepositPwdManager.h
//  VirtualPayment
//
//  Created by silicn on 2020/4/3.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "QGDeposit.h"


@class QGDepositeCardModel;

NS_ASSUME_NONNULL_BEGIN

typedef void(^QGDepositTradeResultBlock)(BOOL success, NSString * _Nullable tradeNo,NSString * _Nullable message);

@interface QGDepositPwdManager : NSObject

///---------------------必要参数--------------------

///转入转出类型,默认转入
@property (nonatomic, assign) QGDepositType type;
/// 金额
@property (nonatomic, copy) NSString *amount ;
/// 转出账户
@property (nonatomic, strong)QGDepositeCardModel *card;


///------------------------------------------------------

/// 父视图
@property (nonatomic, strong) UIView *superView;

/// 交易结果回调
@property (nonatomic, copy) QGDepositTradeResultBlock tradeResultBlock ;



+ (instancetype)shareManager;

/// 便利构造器
/// @param type 类型
/// @param amount 金额
/// @param card 转出账户
+ (instancetype)defaultMangerWithType:(QGDepositType)type amount:(NSString *)amount card:(QGDepositeCardModel *)card;

/// 展示的视图
- (void)showInView:(nullable UIView *)superView;


@end

NS_ASSUME_NONNULL_END
