//
//  QGDepositViewController.m
//  VirtualPayment
//
//  Created by silicn on 2020/3/31.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGDepositViewController.h"

#import "QGGradientView.h"

#import "QGDepositeViewCell.h"
#import "QGDepositTipViewCell.h"

#import "QGDepositRequestApi.h"

@interface QGDepositViewController ()<UITableViewDelegate,UITableViewDataSource>

@property (nonatomic, strong)UITableView *tableView;
/// 金额Label
@property (nonatomic, strong)UILabel *amountLab;
/// 卡号Label
@property (nonatomic, strong) UILabel *cardNoLab ;
/// 卡后后四位
@property (nonatomic, copy) NSString *cardTailNo ;
/// 银行名字
@property (nonatomic, copy) NSString *cardName;
/// 卡号
@property (nonatomic, copy) NSString *cardNo;
///提示信息
@property (nonatomic, copy) NSString *tip ;
/// 转账明细URL
@property (nonatomic, copy) NSString *depositRecordUrl ;
/// 网银操作引导
@property (nonatomic, copy) NSString *mobileJumpUrl ;

@end

@implementation QGDepositViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

- (void)transferParameters:(NSDictionary *)param
{
    
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self setupNavigation];
    
    [self initNomalUI];
    
    [self requestData];
    
    // Do any additional setup after loading the view.
}

/// 设置导航
- (void)setupNavigation
{
    [self setNavBarIsGradientBar:YES];
    
    UILabel *titleView = [[UILabel alloc]initWithFrame:CGRectMake(0, 0, 60, 44)];
    titleView.font = [UIFont qg_mediumFontOfSize:17.0f];
    titleView.text = @"存款入金";
    titleView.textColor = UIColor.whiteColor;
    self.navigationItem.titleView = titleView;
    [self custemLeftWhiteBarButtonItem];
}

- (void)initNomalUI
{
    self.view.backgroundColor = [UIColor whiteColor];
    /// 头部背景渐变色
    QGGradientView *gradientView = [[QGGradientView alloc]init];
    [self.view addSubview:gradientView];
    [gradientView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(self.view);
        if (@available(iOS 11.0, *)) {
            make.top.equalTo(self.view.mas_safeAreaLayoutGuideTop);
        } else {
            make.top.equalTo(self.view.mas_top).inset(64);
        }
        make.height.equalTo(gradientView.mas_width).multipliedBy(160/375.0);
    }];
    
    /// tableView
    self.tableView = [[UITableView alloc]initWithFrame:CGRectZero style:UITableViewStyleGrouped];
    _tableView.delegate = self;
    _tableView.dataSource = self;
    [self.view addSubview:_tableView];
    _tableView.backgroundColor = UIColor.clearColor;
    _tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
    _tableView.estimatedRowHeight = 60;
    _tableView.bouncesZoom = NO;
    _tableView.rowHeight = UITableViewAutomaticDimension;
    
   [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.equalTo(self.view);
        if (@available(iOS 11.0, *)) {
            make.top.equalTo(self.view.mas_safeAreaLayoutGuideTop);
        } else {
            make.top.equalTo(self.view.mas_top).inset(64);
        }
    }];
    
    /// headerView
    CGFloat kScreenWidth = [UIScreen mainScreen].bounds.size.width;
    CGFloat headerHeight = kScreenWidth * (140/375.0);
    
    QGGradientView *headerView = [[QGGradientView alloc]init];
    headerView.frame = CGRectMake(0, 0, kScreenWidth, headerHeight);
    self.tableView.tableHeaderView = headerView;
    /// 标题
    UILabel *headerTitleLab = [UIView creatLabelWithSuperView:headerView title:@"储蓄账户余额(元)" titleFontSize:[UIFont qg_lightFontOfSize:12.0f] textColor:UIColor.whiteColor alignment:NSTextAlignmentCenter];
    [headerTitleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.inset(16.0f);
        make.centerX.equalTo(headerView);
    }];
    /// 转账明细
    UIButton *detaiBtn = [UIButton creatButtonWithSuperView:headerView title:@"转账明细>>" titleFont:[UIFont qg_regularFontOfSize:12.0f] textColor:UIColor.whiteColor];
    [detaiBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.inset(20);
        make.centerY.equalTo(headerTitleLab);
    }];
    
    [detaiBtn addTarget:self action:@selector(toDepositeDetail) forControlEvents:UIControlEventTouchUpInside];
    
    /// 金额
    UILabel *amountLab =[UILabel creatLabelWithSuperView:headerView title:@"0.00" titleFontSize:[UIFont qg_numberFontOfSize:25.0f] textColor:UIColor.whiteColor alignment:NSTextAlignmentCenter];
    [amountLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(headerView);
        make.centerY.equalTo(headerView).offset(-15);
    }];
    self.amountLab = amountLab;
    
    /// Card No
    UILabel *cardNoLab = [UILabel creatLabelWithSuperView:headerView title:@"卡号" titleFontSize:[UIFont qg_lightFontOfSize:14.0f]  textColor:UIColor.whiteColor alignment:NSTextAlignmentLeft];
    [cardNoLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(20);
        make.bottom.inset(16);
    }];
    self.cardNoLab = cardNoLab;
    
    /// 复制卡号
    UIButton *pasteBtn = [UIButton creatButtonWithSuperView:headerView title:@"   复制卡号   " titleFont:[UIFont qg_lightFontOfSize:12.0f] textColor:UIColor.whiteColor];
    pasteBtn.layer.cornerRadius = 10;
    pasteBtn.layer.borderColor = UIColor.whiteColor.CGColor;
    pasteBtn.layer.borderWidth = 1;
    pasteBtn.layer.masksToBounds = YES;
    [pasteBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.inset(20);
        make.height.mas_equalTo(20);
        make.centerY.equalTo(cardNoLab);
    }];
    
    [pasteBtn addTarget:self action:@selector(pasteCardNo:) forControlEvents:UIControlEventTouchUpInside];
}

#pragma mark - Request

- (void)requestData
{
    QGTalosNetwork *netWork = [QGTalosNetwork shareManager];
    [QGHUDManager showHud:nil];
    [netWork GET:[QGDepositRequestApi urlWithIndex:QGCardRequestServerMethodDeposit] parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *data = responseObject[@"data"];
            [self refreshUIWithData:data];
        }else{
            [QGHUDManager showHud:responseObject[@"msg"] ? responseObject[@"msg"] :@"获取信息错误"];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
         [QGHUDManager hideHud];
        @weakify(self);
        QGDefaultView * view = [QGDefaultView defaultViewShowWithSuperView:self.view reloadBlock:^{
            @strongify(self);
            [self requestData];
        }];
        view.viewType = QGDefaultViewTypeBadNetwork;
    }];
}

- (void)refreshUIWithData:(NSDictionary *)data
{
    self.amountLab.text = data[@"amount"] ? data[@"amount"]:@"0.00";
    self.cardNoLab.text = [NSString stringWithFormat:@"卡号 %@",data[@"eCardNo"]];
    self.tip = data[@"tip"];
    self.cardNo = data[@"eCardNo"];
    self.cardTailNo = data[@"tailCardNo"];
    self.cardName = data[@"bankName"];
    self.depositRecordUrl = data[@"depositRecordUrl"];
    self.mobileJumpUrl = data[@"mobileJumpUrl"];
    [self.tableView reloadData];
}


#pragma mark - 自定义方法

- (void)pasteCardNo:(UIButton *)btn
{
    if (self.cardNo) {
        UIPasteboard * pasteboard = [UIPasteboard generalPasteboard];
        pasteboard.string = self.cardNo;
        pasteboard.strings = @[self.cardNo];
        [QGHUDManager showHud:@"复制成功"];
    }else{
         [QGHUDManager showHud:@"获取卡号错误"];
    }
}

- (void)toDepositeDetail
{
    [self navigationToWeb:self.depositRecordUrl];
    QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"存款入金" path:@"转账明细" name:@"转入/出记录" detail_name:nil];
    [QGAnalyticsService analyticsTrackWithEvent:event];
}

#pragma mark - TableView Delegate & DataSource

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 3;
}

// Row display. Implementers should *always* try to reuse cells by setting each cell's reuseIdentifier and querying for available reusable cells with dequeueReusableCellWithIdentifier:
// Cell gets various attributes set automatically based on table (separators) and data source (accessory views, editing controls)

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 2) {
        /// 底部提示cell
        QGDepositTipViewCell *cell =  (QGDepositTipViewCell *)[self getCellFromClassName:NSStringFromClass([QGDepositTipViewCell class]) dequeueTableView:tableView];
        cell.tip = self.tip;
        return cell;
    }
    
    QGDepositeViewCell *cell =  (QGDepositeViewCell *)[self getCellFromClassName:NSStringFromClass([QGDepositeViewCell class]) dequeueTableView:tableView];
    if (indexPath.row == 0) {
        cell.titleLab.text = @"转入";
        cell.subTextLab.text = [NSString stringWithFormat:@"从%@(%@)银行卡直接代扣转入",self.cardName ? self.cardName:@"",self.cardTailNo ? self.cardTailNo :@"****"];
        cell.imageV.image = [UIImage imageNamed:@"deposit_style_in"];
    }else if (indexPath.row == 1){
        cell.titleLab.text = @"手机银行转入";
        cell.subTextLab.text = [NSString stringWithFormat:@"从%@(%@)手机银行或网银转入",self.cardName ? self.cardName:@"",self.cardTailNo ? self.cardTailNo :@"****"];
        cell.imageV.image = [UIImage imageNamed:@"deposit_style_mobile"];
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    if (indexPath.row == 0) {
        [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGDepositeRecordedViewController) parameters:@{@"type":@(1)} handlerBlock:NULL];
        QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"存款入金" path:@"转入" name:@"转入" detail_name:nil];
        [QGAnalyticsService analyticsTrackWithEvent:event];
    }else if(indexPath.row == 1){
        [self navigationToWeb:self.mobileJumpUrl];
        QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"存款入金" path:@"手机银行转入" name:@"手机银行转入" detail_name:nil];
        [QGAnalyticsService analyticsTrackWithEvent:event];
    }
}


- (void)scrollViewDidScroll:(UIScrollView *)scrollView
{
    /// 禁止滑动距离过大
    CGFloat kScreenWidth = [UIScreen mainScreen].bounds.size.width;
    CGFloat headerHeight = kScreenWidth * (140/375.0) - 1;
    if (scrollView.contentOffset.y < -headerHeight) {
        [self.tableView setContentOffset:CGPointMake(0, -headerHeight)];
    }
}



- (UIStatusBarStyle)preferredStatusBarStyle
{
    return UIStatusBarStyleLightContent;
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
