//
//  QGDepositResultViewController.h
//  VirtualPayment
//
//  Created by silicn on 2020/4/1.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBaseViewController.h"

#import "QGDeposit.h"


typedef NS_ENUM(NSInteger,QGDepositResultViewType)
{
    QGDepositResultViewTypeNone = 0,  /// 默认加载中
    QGDepositResultViewTypeSuccess,   /// 转账成功
    QGDepositResultViewTypeFailure,   /// 转账失败
    QGDepositResultViewTypeWaiting    /// 正在转账
};

NS_ASSUME_NONNULL_BEGIN

typedef void(^QGDepositResultActionBlock)(QGDepositResultViewType viewType);

@interface QGDepositResultViewController : QGBaseViewController

/// 转入转出类型
@property (nonatomic, assign)QGDepositType type;
/// 交易单号
@property (nonatomic, copy) NSString *tradeNo ;
/// 转账记录
@property (nonatomic, copy) NSString *recordURL;
/// 再转一笔的回调
@property (nonatomic, copy) QGDepositResultActionBlock actionBlock;

@end

NS_ASSUME_NONNULL_END
