//
//  QGCreditApplyViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/1.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGCreditApplyViewController.h"

#import "QGCreditApplyHeaderCell.h"
#import "QGCreditApplySubmitCell.h"

#import "QGCardRequestApi.h"
#import "QGApplicationOpenURL.h"
#import "QGFaceVerifyManager.h"
#import <UMAnalytics/MobClick.h>

@interface QGCreditApplyViewController ()
///是否已同意用户协议
@property (assign, nonatomic) BOOL isSelect;
@end

@implementation QGCreditApplyViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

- (UIStatusBarStyle)preferredStatusBarStyle
{
    return UIStatusBarStyleLightContent;
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self custemLeftWhiteBarButtonItem];
    [self setNavBarIsGradientBar:YES];
    [self setupNavBarTitleColor:[UIColor whiteColor] title:@"额度申请"];
    self.tableView.bounces = NO;
}

#pragma mark - UITableViewDataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 2;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.row) {
            //顶部banner
        case 0:
        {
            QGCreditApplyHeaderCell * cell = (QGCreditApplyHeaderCell *)[self getCellFromClassName:NSStringFromClass([QGCreditApplyHeaderCell class]) dequeueTableView:tableView];
            return cell;
        }
            break;
        case 1:
        {
            QGCreditApplySubmitCell * cell = (QGCreditApplySubmitCell *)[self getCellFromClassName:NSStringFromClass([QGCreditApplySubmitCell class]) dequeueTableView:tableView];
            
            cell.isAgree = self.isSelect;
            
            @weakify(self);
            cell.agreementClick = ^(NSString *urlStr) {
                @strongify(self);
                [self navigationToWeb:urlStr];
            };
            
            //同意协议
            cell.agressClick = ^{
                @strongify(self);
                self.isSelect = !self.isSelect;
            };
            
            //立即申请按钮
            [cell.submitButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
                @strongify(self);
                [self activateButtonClick];
            }];
            return cell;
        }
            break;
            
        default:
            break;
    }
    
    return [UITableViewCell new];
}

#pragma mark - UITableViewDelegate
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CGFloat heightForRow = 0;
    switch (indexPath.row) {
            //顶部header
        case 0:
            heightForRow = 220;
            break;
            //协议和按钮
        case 1:
            heightForRow = 160;
            break;
            
        default:
            break;
    }
    return heightForRow;
}

#pragma mark - Action
///激活按钮点击事件
- (void)activateButtonClick
{
    if (!self.isSelect) {
        [QGHUDManager showHud:@"请阅读并同意协议"];
        return;
    }
    
    [QGHUDManager showHud:nil];
    
    NSString * urlString = [QGCardRequestApi urlWithIndex:QGCardRequestServerMethodActiveCreditApply];
//    urlString = @"http://yapi.quantgroups.com/mock/305/vcc/account/active_credit_limit";
    
    [[QGTalosNetwork shareManager] GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHudAnimated:YES];
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary * dataDic = responseObject[@"data"];
            //激活页面URL 每次跳转需要重新请求
            NSString * activateUrl = dataDic[@"url"];
              [self checkUrlAndJumpWithuUrlString:activateUrl];
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        NSString * errorMessage = [QGBaseNetwork getMessageWithFailureError:error];
        [QGHUDManager showHud:errorMessage];
    }];
}

///检查URL并跳转
- (void)checkUrlAndJumpWithuUrlString:(NSString *)urlString
{
    
    @weakify(self);
    //此处产品要求所有的跳转和回调能够连成一条线。因此只支持URL和活体协议
    XYQBJumpType jumpType =  [[QGApplicationOpenURL shareInstance] autoParseURL:[NSURL URLWithString:urlString]];
    if (jumpType == XYQBJumpTypeHttp)
    {
        [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeCWWebViewController] parameters:@{@"urlString":urlString} handlerBlock:^(NSString *tag, NSDictionary *parameters) {
            @strongify(self);
            if ([tag isEqualToString:WebView_ReopenBrowserWithNewUrl]) {
                NSString * urlString = parameters[@"urlString"];
                //不管回来的是什么样的URL，进行递归操作
                [self checkUrlAndJumpWithuUrlString:urlString];
            }
        }];
    }
    //如果是活体
    else if (jumpType == XYQBJumpTypeFaceEntrance)
    {
        [QGFaceVerifyManager.shareInstance openFaceVerifySuccess:^{
            @strongify(self);
            [MobClick event:@"AppFaceLivingSuccess"];
            [self activateButtonClick];
        }];
        
    }
    //如果运营人员配错其他页面也能支持跳转
    else
    {
        [QGApplicationOpenURL handleAllSupportUrl:urlString callbackBolck:nil];
    }
    
    
}

@end
